/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.log;

import com.global.base.log.ILogPrintSink;
import com.global.base.log.LogInfoData;
import com.global.base.log.LogLevelFlag;
import com.global.base.log.LogTaskQueueHandlerPool;
import com.global.base.tools.TraceIdUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogPrintMgr {
    public static final String ALL_BUSI_SWITCH = "ALL_BUSI";
    public static final String DEFAULT_REQUEST = "Inner";
    private static volatile LogPrintMgr msInstance = null;
    private Logger mLogger = LoggerFactory.getLogger(this.getClass());
    private ILogPrintSink mSink = null;
    private volatile boolean mBSwitchTraceLog = true;
    private volatile boolean mBInfoPrintForAllBusi = true;
    private volatile HashMap<String, Boolean> mMapInfoType2Flag = new HashMap(10);

    private LogPrintMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogPrintMgr getInstance() {
        if (msInstance != null) return msInstance;
        Class<LogPrintMgr> clazz = LogPrintMgr.class;
        synchronized (LogPrintMgr.class) {
            if (msInstance != null) return msInstance;
            msInstance = new LogPrintMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return msInstance;
        }
    }

    public void initRes(int nPoolSize, ILogPrintSink sink) {
        this.mSink = sink;
        if (!LogTaskQueueHandlerPool.getInstance().isInited()) {
            LogTaskQueueHandlerPool.getInstance().init(nPoolSize);
        }
    }

    public boolean isSwitchTraceLog() {
        return this.mBSwitchTraceLog;
    }

    public void setSwitchTraceLog(boolean mBSwitchTraceLog) {
        this.mBSwitchTraceLog = mBSwitchTraceLog;
    }

    public ILogPrintSink getPrintSink() {
        return this.mSink;
    }

    public boolean getLogSwitch(LogLevelFlag nLevel, String busiType) {
        boolean bRes = true;
        switch (nLevel) {
            case LOG_INFO: {
                if (ALL_BUSI_SWITCH.equals(busiType)) {
                    bRes = this.mBInfoPrintForAllBusi;
                    break;
                }
                if (!this.mMapInfoType2Flag.containsKey(busiType)) break;
                bRes = this.mMapInfoType2Flag.get(busiType);
                break;
            }
            case LOG_WARN: {
                break;
            }
            case LOG_ERROR: {
                break;
            }
        }
        return bRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogSwitch(LogLevelFlag nLevel, String busiType, boolean bPrintOrNot) {
        LogPrintMgr logPrintMgr = this;
        synchronized (logPrintMgr) {
            switch (nLevel) {
                case LOG_INFO: {
                    if (ALL_BUSI_SWITCH.equals(busiType)) {
                        this.mBInfoPrintForAllBusi = bPrintOrNot;
                        break;
                    }
                    this.mMapInfoType2Flag.put(busiType, bPrintOrNot);
                    break;
                }
                case LOG_WARN: {
                    break;
                }
                case LOG_ERROR: {
                    break;
                }
            }
        }
    }

    private boolean filterLogBeforePrint(LogLevelFlag nLevel, String busiType) {
        boolean bRes = true;
        switch (nLevel) {
            case LOG_INFO: {
                if (this.mBInfoPrintForAllBusi) {
                    if (!this.mMapInfoType2Flag.containsKey(busiType)) break;
                    bRes = this.mMapInfoType2Flag.get(busiType);
                    break;
                }
                bRes = false;
                break;
            }
            case LOG_WARN: {
                break;
            }
            case LOG_ERROR: {
                break;
            }
        }
        return bRes;
    }

    private void syncPrintLogMsg(String traceId, LogLevelFlag nLevel, String strClassname, String strRequester, String strMsg) {
        switch (nLevel) {
            case LOG_INFO: {
                if (this.mSink != null) {
                    this.mSink.printLogMsg(LogLevelFlag.LOG_INFO.ordinal(), String.format("[%s]--[%s]--[%s]--[%s] %s", traceId, Thread.currentThread().getName(), strClassname, strRequester, strMsg));
                    break;
                }
                this.mLogger.info("[{}]--[{}]--[{}]--[{}] {}", traceId, Thread.currentThread().getName(), strClassname, strRequester, strMsg);
                break;
            }
            case LOG_WARN: {
                if (this.mSink != null) {
                    this.mSink.printLogMsg(LogLevelFlag.LOG_WARN.ordinal(), String.format("[%s]--[%s]--[%s]--[%s] %s", traceId, Thread.currentThread().getName(), strClassname, strRequester, strMsg));
                    break;
                }
                this.mLogger.warn("[{}]--[{}]--[{}]--[{}] {}", traceId, Thread.currentThread().getName(), strClassname, strRequester, strMsg);
                break;
            }
            case LOG_ERROR: {
                if (this.mSink != null) {
                    this.mSink.printLogMsg(LogLevelFlag.LOG_ERROR.ordinal(), String.format("[%s]--[%s]--[%s]--[%s] %s", traceId, Thread.currentThread().getName(), strClassname, strRequester, strMsg));
                    break;
                }
                this.mLogger.error("[{}]--[{}]--[{}]--[{}] {}", traceId, Thread.currentThread().getName(), strClassname, strRequester, strMsg);
                break;
            }
        }
    }

    private void syncPrintLogMsg(LogLevelFlag nLevel, String strClassname, String strMsg) {
        this.syncPrintLogMsg(this.mBSwitchTraceLog ? TraceIdUtil.getTraceId() : "TID-0", nLevel, strClassname, DEFAULT_REQUEST, strMsg);
    }

    public void printLogMsg(LogLevelFlag nLevel, String busiType, String strClassName, String strRequester, String strMsg) {
        if (!this.filterLogBeforePrint(nLevel, busiType)) {
            return;
        }
        this.printLogMsgInter(nLevel, strClassName, strRequester, String.format("[%s] %s", busiType, strMsg));
    }

    public void printLogMsg(LogLevelFlag nLevel, String busiType, String strClassName, String strMsg) {
        this.printLogMsg(nLevel, busiType, strClassName, DEFAULT_REQUEST, strMsg);
    }

    private void printLogMsgInter(LogLevelFlag nLevel, String strClassName, String strRequester, String strMsg) {
        String strTraceId;
        boolean bRes = false;
        String string = strTraceId = this.mBSwitchTraceLog ? TraceIdUtil.getTraceId() : "TID-0";
        if (LogTaskQueueHandlerPool.getInstance().isInited()) {
            bRes = LogTaskQueueHandlerPool.getInstance().postTaskData(new LogInfoData(nLevel, String.format("[%s]--[%s]--[%s]--[%s] %s", strTraceId, Thread.currentThread().getName(), strClassName, strRequester, strMsg)));
        }
        if (!bRes) {
            this.syncPrintLogMsg(strTraceId, nLevel, strClassName, strRequester, strMsg);
        }
    }

    private void printLogMsgInter(LogLevelFlag nLevel, String strClassName, String strMsg) {
        this.printLogMsgInter(nLevel, strClassName, DEFAULT_REQUEST, strMsg);
    }

    public void printExceptionObject(LogLevelFlag nLevel, Exception ex) {
        if (ex == null) {
            return;
        }
        switch (nLevel) {
            case LOG_WARN: {
                try {
                    this.mLogger.warn(ex.getMessage(), ex);
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                try {
                    this.mLogger.error(ex.getMessage(), ex);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

