/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.log;

import com.global.base.log.LogInfoData;
import com.global.base.log.LogLevelFlag;
import com.global.base.log.LogPrintMgr;
import com.lmax.disruptor.WorkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConsumerWork
implements WorkHandler<LogInfoData> {
    private final Logger mLogger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onEvent(LogInfoData event) throws Exception {
        if (event == null) {
            return;
        }
        switch (event.getmNLevel()) {
            case LOG_INFO: {
                if (LogPrintMgr.getInstance().getPrintSink() != null) {
                    LogPrintMgr.getInstance().getPrintSink().printLogMsg(LogLevelFlag.LOG_INFO.ordinal(), event.getmStrMsg());
                    break;
                }
                this.mLogger.info(event.getmStrMsg());
                break;
            }
            case LOG_WARN: {
                if (LogPrintMgr.getInstance().getPrintSink() != null) {
                    LogPrintMgr.getInstance().getPrintSink().printLogMsg(LogLevelFlag.LOG_WARN.ordinal(), event.getmStrMsg());
                    break;
                }
                this.mLogger.warn(event.getmStrMsg());
                break;
            }
            case LOG_ERROR: {
                if (LogPrintMgr.getInstance().getPrintSink() != null) {
                    LogPrintMgr.getInstance().getPrintSink().printLogMsg(LogLevelFlag.LOG_ERROR.ordinal(), event.getmStrMsg());
                    break;
                }
                this.mLogger.error(event.getmStrMsg());
                break;
            }
        }
    }
}

