/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.licensemgr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LicenseMgr {
    private static AtomicBoolean mBLicensePass = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeLinuxCmd(String cmdLine) {
        StringBuilder result = new StringBuilder("");
        Process proc = null;
        BufferedReader reader = null;
        try {
            String[] cmd = new String[]{"/bin/sh", "-c", cmdLine};
            proc = Runtime.getRuntime().exec(cmd);
            try {
                proc.waitFor(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String tmp = "";
            while ((tmp = reader.readLine()) != null) {
                result.append(tmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            catch (Exception exception) {}
        }
        return result.toString().trim().toUpperCase();
    }

    private static String getSNForLinux(String tag) {
        switch (tag) {
            case "MB": {
                return LicenseMgr.executeLinuxCmd("dmidecode -t System Information | grep \"UUID\" | sort -u | awk -F': ' '{print $2}'");
            }
            case "CPU": {
                String tmp = LicenseMgr.executeLinuxCmd("dmidecode -t processor | grep ID | sort -u | awk -F': ' '{print $2}'");
                return tmp;
            }
            case "DISK": {
                String tmp = LicenseMgr.executeLinuxCmd("fdisk -l | grep -E \"Disk identifier|\u78c1\u76d8\u6807\u8bc6\u7b26\" | sort -u | awk -F': |\uff1a' '{print $2}'");
                return tmp;
            }
        }
        return "";
    }

    private static String getSNForWin(String tag) {
        StringBuilder result = new StringBuilder("");
        try {
            File file = File.createTempFile(System.currentTimeMillis() + "_" + tag, ".vbs");
            file.deleteOnExit();
            FileWriter fw = new FileWriter(file);
            String vbs = "";
            switch (tag) {
                case "MB": {
                    vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
                    break;
                }
                case "CPU": {
                    vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_Processor\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.ProcessorId \n    exit for  ' do the first cpu only! \nNext \n";
                    break;
                }
                case "DISK": {
                    vbs = "Set objFSO = CreateObject(\"Scripting.FileSystemObject\")\nSet colDrives = objFSO.Drives\nSet objDrive = colDrives.item(\"C\")\nWscript.Echo objDrive.SerialNumber";
                }
            }
            fw.write(vbs);
            fw.close();
            Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath().replace("%20", " "));
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = input.readLine()) != null) {
                result.append(line);
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString().trim().toUpperCase();
    }

    private static String getSNForThisSystem(String tag) {
        String os = System.getProperty("os.name").toUpperCase();
        if (os.contains("LINUX")) {
            return LicenseMgr.getSNForLinux(tag);
        }
        return LicenseMgr.getSNForWin(tag);
    }

    public static String getSystemInfo() {
        return String.format("{\"CPU\":\"%s\",\"MB\":\"%s\",\"DISK\":\"%s\"}", LicenseMgr.getSNForThisSystem("CPU").replaceAll("[\n\r]", ""), LicenseMgr.getSNForThisSystem("MB").replaceAll("[\n\r]", ""), LicenseMgr.getSNForThisSystem("DISK").replaceAll("[\n\r]", ""));
    }

    public static String getKey() {
        return "lic@shkpr-6dzht7";
    }

    public static void reInit(Map<String, String> licenseObj) {
        if (licenseObj != null && licenseObj.size() > 0) {
            String cpuSN = LicenseMgr.getSNForThisSystem("CPU").replaceAll("[\n\r]", "");
            String mbSN = LicenseMgr.getSNForThisSystem("MB").replaceAll("[\n\r]", "");
            String diskSN = LicenseMgr.getSNForThisSystem("DISK").replaceAll("[\n\r]", "");
            String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            try {
                if (cpuSN.equalsIgnoreCase(licenseObj.getOrDefault("cpu_id", "")) && mbSN.equalsIgnoreCase(licenseObj.getOrDefault("board_id", "")) && diskSN.equalsIgnoreCase(licenseObj.getOrDefault("disk_id", "")) && date.compareTo(licenseObj.getOrDefault("end", "")) <= 0) {
                    mBLicensePass.set(true);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mBLicensePass.set(false);
    }

    public static boolean check() {
        return mBLicensePass.get();
    }
}

