/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SnowFlakeEx {
    private static final String RandomSeed = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static volatile SnowFlakeEx msInstance = null;
    private static final long START_STAMP = 1000000000000L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long BACKUP_MACHINE_BIT = 2L;
    private static final long BUSINESS_SERVICE_BIT = 3L;
    private static final long MAX_BUSI_SERVICE_NUM = 7L;
    private static final long MAX_BACKUP_MACHINE_NUM = 3L;
    private static final long MAX_MACHINE_NUM = 31L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long BUSI_SERVICE_LEFT = 12L;
    private static final long MACHINE_LEFT = 15L;
    private static final long BACKUP_MACHINE_LEFT = 20L;
    private static final long TIMESTAMP_LEFT = 22L;
    private static final long MAX_BACKWARD_MS = 3L;
    private long busiServiceId = 0L;
    private long backupMachineId = 0L;
    private long machineId = 0L;
    private long beginSequence = 0L;
    private long sequence = 0L;
    private long lastStamp = -1L;
    private long initMachineID = 0L;
    private Map<Long, Long> machineIdLastTimeMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean init(long machineId, long busiServiceId) {
        if (msInstance == null) {
            Class<SnowFlakeEx> clazz = SnowFlakeEx.class;
            // MONITORENTER : com.global.base.component.SnowFlakeEx.class
            if (msInstance == null) {
                msInstance = new SnowFlakeEx(machineId, busiServiceId);
            }
            // MONITOREXIT : clazz
        }
        if (msInstance == null) return false;
        return true;
    }

    public static void unInit() {
        if (msInstance != null) {
            msInstance.clearRes();
        }
        msInstance = null;
    }

    public static SnowFlakeEx getInstance() {
        if (msInstance == null) {
            throw new NullPointerException("Please init() first before using this function");
        }
        return msInstance;
    }

    private SnowFlakeEx(long machineId, long busiServiceId) {
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        if (busiServiceId > 7L || busiServiceId < 0L) {
            throw new IllegalArgumentException("busiServiceId can't be greater than MAX_BUSI_SERVICE_NUM or less than 0");
        }
        this.machineId = machineId;
        this.initMachineID = machineId;
        this.busiServiceId = busiServiceId;
        if (this.machineIdLastTimeMap == null) {
            this.machineIdLastTimeMap = new ConcurrentHashMap<Long, Long>();
        }
        int i = 0;
        while ((long)i <= 3L) {
            this.machineIdLastTimeMap.put(machineId + (long)i * 32L, 0L);
            ++i;
        }
    }

    private void clearRes() {
        if (this.machineIdLastTimeMap != null) {
            this.machineIdLastTimeMap.clear();
        }
        this.busiServiceId = 0L;
        this.backupMachineId = 0L;
        this.machineId = 0L;
        this.sequence = 0L;
        this.beginSequence = 0L;
        this.lastStamp = -1L;
        this.initMachineID = 0L;
    }

    public synchronized long nextId() {
        long curStamp = System.currentTimeMillis();
        if (curStamp < this.lastStamp) {
            if (this.lastStamp - curStamp < 3L) {
                try {
                    Thread.sleep(this.lastStamp - curStamp);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                this.tryGenerateIdOnBackup(curStamp);
            }
            curStamp = System.currentTimeMillis();
        }
        if (curStamp == this.lastStamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == this.beginSequence) {
                curStamp = this.getNextMill(curStamp);
            }
        } else {
            long h4bit = Math.round(Math.random() * 10.0);
            long m4bit = Math.round(Math.random() * 10.0);
            long l4bit = Math.round(Math.random() * 10.0);
            this.sequence = this.beginSequence = h4bit << 8 | m4bit << 4 | l4bit;
        }
        this.lastStamp = curStamp;
        this.machineIdLastTimeMap.put(this.machineId, this.lastStamp);
        return this.lastStamp - 1000000000000L << 22 | this.backupMachineId << 20 | this.machineId << 15 | this.busiServiceId << 12 | this.sequence;
    }

    public synchronized String nextHexStrId(int lenRandom) {
        long id = this.nextId();
        if (lenRandom > 0) {
            StringBuilder sb = new StringBuilder();
            int len = RandomSeed.length();
            for (int i = 0; i < lenRandom; ++i) {
                sb.append(RandomSeed.charAt((int)Math.round(Math.random() * (double)(len - 1))));
            }
            return Long.toHexString(id).toUpperCase() + sb.toString();
        }
        return Long.toHexString(id).toUpperCase();
    }

    private long getNextMill(long desUTCMs) {
        long mill = System.currentTimeMillis();
        while (mill <= desUTCMs) {
            mill = System.currentTimeMillis();
        }
        return mill;
    }

    private long tryGenerateIdOnBackup(long desUTCMs) {
        for (Map.Entry<Long, Long> entry : this.machineIdLastTimeMap.entrySet()) {
            Long idKey = entry.getKey();
            if (idKey == null || idKey == this.machineId) continue;
            Long tempLastTime = entry.getValue();
            long l = this.lastStamp = tempLastTime == null ? 0L : tempLastTime;
            if (this.lastStamp > desUTCMs) continue;
            this.machineId = entry.getKey();
            this.backupMachineId = (this.machineId - this.initMachineID) / 32L;
            return this.lastStamp;
        }
        throw new IllegalStateException("Clock is moving backwards, current time is " + desUTCMs + " milliseconds, workerId map = " + this.machineIdLastTimeMap);
    }
}

