/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.httpclient;

import com.global.base.httpclient.HttpAsyncClient;

public class HttpClientFactory {
    private HttpAsyncClient mAsyncClient = null;
    private volatile HttpAsyncClient mAsyncClientWithVerifySvrCert = null;
    private static volatile HttpClientFactory msInstance = null;
    private int mSockTime = 20000;
    private int mConnTime = 10000;
    private boolean mBPostWithCert = false;
    private volatile boolean mBVerifyCert = false;
    private volatile String mStrSvrCertDir = "";
    private volatile String mStrLocalKeyPass = "Nr12345678";
    private volatile String mStrLocalKeyPath = "./nengry.pfx";
    private int mNCpuCores = 1;

    private HttpClientFactory() {
    }

    public void init(boolean bPostWithCert, boolean bVerifyCert, String strSvrCertDir, String strLocalKeyPass, String strLocalKeyPath) {
        this.init(this.mSockTime, this.mConnTime, this.mNCpuCores, bPostWithCert, bVerifyCert, strSvrCertDir, strLocalKeyPass, strLocalKeyPath);
    }

    public void init(int cpuCores, boolean bPostWithCert, boolean bVerifyCert, String strSvrCertDir, String strLocalKeyPass, String strLocalKeyPath) {
        this.init(this.mSockTime, this.mConnTime, cpuCores, bPostWithCert, bVerifyCert, strSvrCertDir, strLocalKeyPass, strLocalKeyPath);
    }

    public void init(int nSockTime, int nConnTime, int cpuCores, boolean bPostWithCert, boolean bVerifyCert, String strSvrCertDir, String strLocalKeyPass, String strLocalKeyPath) {
        this.mNCpuCores = cpuCores < 1 ? 1 : cpuCores;
        this.mStrSvrCertDir = strSvrCertDir;
        this.mBVerifyCert = bVerifyCert;
        this.mBPostWithCert = bPostWithCert;
        this.mSockTime = nSockTime < 20000 ? 20000 : nSockTime;
        this.mSockTime = this.mSockTime > 60000 ? 60000 : this.mSockTime;
        this.mConnTime = nConnTime < 10000 ? 10000 : nConnTime;
        int n = this.mConnTime = this.mConnTime > 60000 ? 60000 : this.mConnTime;
        if (bPostWithCert) {
            this.mStrLocalKeyPath = strLocalKeyPath;
            this.mStrLocalKeyPass = strLocalKeyPass;
        }
        this.mAsyncClient = new HttpAsyncClient(this.mSockTime, this.mConnTime, this.mNCpuCores, this.mBPostWithCert, false, "", this.mStrLocalKeyPass, this.mStrLocalKeyPath);
        if (this.mBVerifyCert) {
            this.mAsyncClientWithVerifySvrCert = new HttpAsyncClient(this.mSockTime, this.mConnTime, this.mNCpuCores, this.mBPostWithCert, this.mBVerifyCert, this.mStrSvrCertDir, this.mStrLocalKeyPass, this.mStrLocalKeyPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClientFactory getInstance() {
        if (msInstance != null) return msInstance;
        Class<HttpClientFactory> clazz = HttpClientFactory.class;
        synchronized (HttpClientFactory.class) {
            if (msInstance != null) return msInstance;
            msInstance = new HttpClientFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return msInstance;
        }
    }

    public boolean isVerifyCert() {
        return this.mBVerifyCert;
    }

    public void updateVerifyCertFlag(boolean bVerify, String strSvrCertDir) {
        if (this.mBVerifyCert != bVerify) {
            if (bVerify) {
                this.mAsyncClientWithVerifySvrCert = new HttpAsyncClient(this.mSockTime, this.mConnTime, this.mNCpuCores, this.mBPostWithCert, bVerify, strSvrCertDir, this.mStrLocalKeyPass, this.mStrLocalKeyPath);
            }
            this.mBVerifyCert = bVerify;
            this.mStrSvrCertDir = strSvrCertDir;
        }
    }

    public HttpAsyncClient getHttpAsyncClientPool() {
        if (this.mBVerifyCert && this.mAsyncClientWithVerifySvrCert != null) {
            return this.mAsyncClientWithVerifySvrCert;
        }
        return this.mAsyncClient;
    }
}

