/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import com.global.base.tools.ArrayUtil;
import com.global.base.tools.FastJsonUtil;
import com.global.base.tools.StringUtil;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CastUtil {
    public static String castString(Object obj) {
        return CastUtil.castString(obj, "");
    }

    public static String castString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj) : defaultValue;
    }

    public static double castDouble(Object obj) {
        return CastUtil.castDouble(obj, 0.0);
    }

    public static double castDouble(Object obj, double defaultValue) {
        String strValue;
        double doubleValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                doubleValue = Double.parseDouble(strValue);
            }
            catch (Exception e) {
                doubleValue = defaultValue;
            }
        }
        return doubleValue;
    }

    public static float castFloat(Object obj) {
        return CastUtil.castFloat(obj, 0.0f);
    }

    public static float castFloat(Object obj, float defaultValue) {
        String strValue;
        float floatValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                floatValue = Float.parseFloat(strValue);
            }
            catch (Exception e) {
                floatValue = defaultValue;
            }
        }
        return floatValue;
    }

    public static long castLong(Object obj) {
        return CastUtil.castLong(obj, 0L);
    }

    public static long castLong(Object obj, long defaultValue) {
        String strValue;
        long longValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                longValue = Math.round(Double.parseDouble(strValue));
            }
            catch (Exception e) {
                longValue = defaultValue;
            }
        }
        return longValue;
    }

    public static long castUTCLong(Object obj, long defaultValue) {
        if (obj != null && obj instanceof Timestamp) {
            return ((Timestamp)obj).getTime();
        }
        if (obj != null && obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        return CastUtil.castLong(obj, defaultValue);
    }

    public static long castUTCLong(Object obj) {
        return CastUtil.castUTCLong(obj, 0L);
    }

    public static int castInt(Object obj) {
        return CastUtil.castInt(obj, 0);
    }

    public static int castInt(Object obj, int defaultValue) {
        String strValue;
        int intValue = defaultValue;
        if (obj != null && StringUtil.isNotEmpty(strValue = CastUtil.castString(obj))) {
            try {
                intValue = (int)Math.round(Double.parseDouble(strValue));
            }
            catch (Exception e) {
                intValue = defaultValue;
            }
        }
        return intValue;
    }

    public static boolean castBoolean(Object obj) {
        return CastUtil.castBoolean(obj, false);
    }

    public static boolean castBoolean(Object obj, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        if (obj != null) {
            booleanValue = Boolean.parseBoolean(CastUtil.castString(obj));
        }
        return booleanValue;
    }

    public static String[] castStringArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        String[] strArray = new String[objArray.length];
        if (ArrayUtil.isNotEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                strArray[i] = CastUtil.castString(objArray[i]);
            }
        }
        return strArray;
    }

    public static double[] castDoubleArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        double[] doubleArray = new double[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                doubleArray[i] = CastUtil.castDouble(objArray[i]);
            }
        }
        return doubleArray;
    }

    public static long[] castLongArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        long[] longArray = new long[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                longArray[i] = CastUtil.castLong(objArray[i]);
            }
        }
        return longArray;
    }

    public static int[] castIntArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        int[] intArray = new int[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                intArray[i] = CastUtil.castInt(objArray[i]);
            }
        }
        return intArray;
    }

    public static boolean[] castBooleanArray(Object[] objArray) {
        if (objArray == null) {
            objArray = new Object[]{};
        }
        boolean[] booleanArray = new boolean[objArray.length];
        if (!ArrayUtil.isEmpty(objArray)) {
            for (int i = 0; i < objArray.length; ++i) {
                booleanArray[i] = CastUtil.castBoolean(objArray[i]);
            }
        }
        return booleanArray;
    }

    public static String castMs2Ns(String ms) {
        return ms + "000000";
    }

    public static List<Field> getAllFiled(Object obj) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        if (obj == null) {
            return fieldList;
        }
        for (Class<?> clazz = obj.getClass(); clazz != null && !clazz.getName().equalsIgnoreCase("java.lang.Object"); clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        return fieldList;
    }

    public static boolean objBaseClone(Object objSrc, Object objDes) {
        if (objSrc == null || objDes == null) {
            return false;
        }
        if (!objSrc.getClass().getSimpleName().equals(objDes.getClass().getSimpleName()) && !objSrc.getClass().isAssignableFrom(objDes.getClass())) {
            return false;
        }
        try {
            List<Field> fieldsSrc = CastUtil.getAllFiled(objSrc);
            List<Field> fieldsDes = CastUtil.getAllFiled(objDes);
            block2: for (Field fieldS : fieldsSrc) {
                fieldS.setAccessible(true);
                String filedNameS = fieldS.getName();
                Object filedDataS = fieldS.get(objSrc);
                for (Field fieldD : fieldsDes) {
                    fieldD.setAccessible(true);
                    String filedNameD = fieldD.getName();
                    if (!filedNameS.equals(filedNameD)) continue;
                    if (filedDataS == null) {
                        fieldD.set(objDes, null);
                        continue block2;
                    }
                    if (filedDataS instanceof List) {
                        fieldD.set(objDes, FastJsonUtil.fromJSONByGson(FastJsonUtil.toJSON(filedDataS), List.class));
                        continue block2;
                    }
                    if (filedDataS instanceof Map) {
                        fieldD.set(objDes, FastJsonUtil.fromJSONByGson(FastJsonUtil.toJSON(filedDataS), Map.class));
                        continue block2;
                    }
                    if (filedDataS instanceof Set) {
                        fieldD.set(objDes, FastJsonUtil.fromJSONByGson(FastJsonUtil.toJSON(filedDataS), Set.class));
                        continue block2;
                    }
                    fieldD.set(objDes, filedDataS);
                    continue block2;
                }
            }
            fieldsSrc.clear();
            fieldsDes.clear();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

