/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.global.base.tools.CastUtil;
import com.google.common.base.CaseFormat;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class FastJsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectMapper objectMapperSnakeCase = new ObjectMapper();
    private static final ObjectMapper objectMapperLowerCamel = new ObjectMapper();

    public static <T> String toJSON(T obj) {
        return FastJsonUtil.toJSON(obj, false, null);
    }

    public static <T> String toJSON(T obj, boolean bLower2UnLine) {
        return FastJsonUtil.toJSON(obj, bLower2UnLine, null);
    }

    public static <T> String toJSON(T obj, boolean bLower2UnLine, Map<String, Set<String>> filterName2Fields) {
        String jsonStr = null;
        if (obj != null) {
            try {
                SimpleFilterProvider filterProvider = null;
                if (filterName2Fields != null && filterName2Fields.size() > 0) {
                    filterProvider = new SimpleFilterProvider();
                    for (Map.Entry<String, Set<String>> entry : filterName2Fields.entrySet()) {
                        filterProvider.addFilter(entry.getKey(), SimpleBeanPropertyFilter.filterOutAllExcept(entry.getValue()));
                    }
                }
                if (bLower2UnLine) {
                    if (filterProvider != null) {
                        objectMapperLowerCamel.setFilterProvider(filterProvider);
                    }
                    jsonStr = objectMapperSnakeCase.writeValueAsString(obj);
                } else {
                    if (filterProvider != null) {
                        objectMapper.setFilterProvider(filterProvider);
                    }
                    jsonStr = objectMapper.writeValueAsString(obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonStr;
    }

    public static <T> T fromJSON(String json, Class<T> type) {
        return FastJsonUtil.fromJSON(json, type, false);
    }

    public static <T> T fromJSON(String json, Class<T> type, boolean bUnLine2Lower) {
        T obj = null;
        if (!StringUtils.isEmpty(json) && !"NULL".equals(json)) {
            try {
                obj = bUnLine2Lower ? (T)objectMapperLowerCamel.readValue(json, type) : (T)objectMapper.readValue(json, type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static <T> T fromJSONByGson(String json, Class<T> type) {
        return FastJsonUtil.fromJSONByGson(json, type, false);
    }

    public static <T> T fromJSONByGson(String json, Class<T> type, boolean bUnLine2Lower) {
        T obj = null;
        if (!StringUtils.isEmpty(json) && !"NULL".equals(json)) {
            try {
                if (bUnLine2Lower) {
                    GsonBuilder gsonBuilder = new GsonBuilder();
                    gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
                    obj = gsonBuilder.create().fromJson(json, type);
                } else {
                    obj = new Gson().fromJson(json, type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, elementClasses);
    }

    public static <T> List<T> fromJSON2List(String json, Class<T> type, boolean bUnLine2Lower) {
        if (!StringUtils.isEmpty(json) && !"NULL".equals(json)) {
            if (bUnLine2Lower) {
                List cacheObj = null;
                try {
                    cacheObj = (List)objectMapper.readValue(json, FastJsonUtil.getCollectionType(ArrayList.class, Object.class));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (cacheObj != null && cacheObj.size() > 0) {
                    ArrayList<T> result = new ArrayList<T>();
                    for (Object item : cacheObj) {
                        T desObj = FastJsonUtil.fromJSONByGson(FastJsonUtil.toJSON(item), type, bUnLine2Lower);
                        if (desObj == null) continue;
                        result.add(desObj);
                    }
                    return result;
                }
            } else {
                JavaType javaType = FastJsonUtil.getCollectionType(ArrayList.class, type);
                try {
                    return (List)objectMapper.readValue(json, javaType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static <T> List<T> fromJSON2List(String json, Class<T> type) {
        return FastJsonUtil.fromJSON2List(json, type, false);
    }

    private static <K, V> Map<K, V> fromJSON2Map(String json, Class<K> keyType, Class<V> valueType, boolean bUnLine2Lower) {
        if (!StringUtils.isEmpty(json) && !"NULL".equals(json)) {
            JavaType javaType = FastJsonUtil.getCollectionType(HashMap.class, keyType, valueType);
            try {
                return (Map)objectMapper.readValue(json, javaType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <K, V> Map<K, V> fromJSON2Map(String json, Class<K> keyType, Class<V> valueType) {
        return FastJsonUtil.fromJSON2Map(json, keyType, valueType, false);
    }

    public static String getFieldLine(Map<String, Object> jsonMap) {
        if (jsonMap == null || jsonMap.isEmpty()) {
            return "";
        }
        String line = "";
        for (Map.Entry<String, Object> entry : jsonMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            line = line + key + "=" + (value instanceof String ? "\"" + value + "\"" : value) + ",";
        }
        return line.substring(0, line.length() - 1);
    }

    public static Map<String, Object> obj2Map(Object obj, boolean bLower2UnLine) {
        HashMap<String, Object> map = null;
        if (obj == null) {
            return map;
        }
        try {
            map = new HashMap<String, Object>();
            List<Field> fields = CastUtil.getAllFiled(obj);
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                if (bLower2UnLine) {
                    fieldName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, fieldName);
                }
                map.put(fieldName, field.get(obj));
            }
            fields.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> obj2Map(Object obj) {
        return FastJsonUtil.obj2Map(obj, false);
    }

    public static <T> T map2Obj(Map<String, Object> map, Class<T> type) {
        return FastJsonUtil.map2Obj(map, type, false);
    }

    public static <T> T map2Obj(Map<String, Object> map, Class<T> type, boolean bUnLine2Lower) {
        T obj = null;
        if (map != null && map.size() > 0) {
            try {
                if (bUnLine2Lower) {
                    GsonBuilder gsonBuilder = new GsonBuilder();
                    gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
                    obj = gsonBuilder.create().fromJson(FastJsonUtil.toJSON(map), type);
                } else {
                    obj = new Gson().fromJson(FastJsonUtil.toJSON(map), type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    public static <T> List<T> batchMap2Obj(List<Map<String, Object>> map, Class<T> type, boolean bUnLine2Lower) {
        ArrayList<T> arrRes = new ArrayList<T>();
        if (map != null && map.size() > 0) {
            for (Map<String, Object> mapObj : map) {
                T oBean = FastJsonUtil.map2Obj(mapObj, type, bUnLine2Lower);
                if (oBean == null) continue;
                arrRes.add(oBean);
            }
        }
        return arrRes;
    }

    public static <T> List<T> batchMap2Obj(List<Map<String, Object>> map, Class<T> type) {
        return FastJsonUtil.batchMap2Obj(map, type, false);
    }

    public static Map<String, Object> objPositiveData2Map(Object obj, boolean bLower2UnLine) {
        HashMap<String, Object> map = null;
        if (obj == null) {
            return map;
        }
        try {
            map = new HashMap<String, Object>();
            List<Field> fields = CastUtil.getAllFiled(obj);
            for (Field field : fields) {
                Object filedData;
                field.setAccessible(true);
                String filedName = field.getName();
                if (bLower2UnLine) {
                    filedName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, filedName);
                }
                if ((filedData = field.get(obj)) == null) continue;
                if (filedData instanceof Integer) {
                    if ((Integer)filedData < 0) continue;
                    map.put(filedName, filedData);
                    continue;
                }
                if (filedData instanceof Long) {
                    if ((Long)filedData < 0L) continue;
                    map.put(filedName, filedData);
                    continue;
                }
                if (filedData instanceof Double) {
                    if (!((Double)filedData >= 0.0)) continue;
                    map.put(filedName, filedData);
                    continue;
                }
                if (filedData instanceof Float) {
                    if (!(((Float)filedData).floatValue() >= 0.0f)) continue;
                    map.put(filedName, filedData);
                    continue;
                }
                map.put(filedName, filedData);
            }
            fields.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, Object> objPositiveData2Map(Object obj) {
        return FastJsonUtil.objPositiveData2Map(obj, false);
    }

    static {
        objectMapperSnakeCase.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapperLowerCamel.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapperSnakeCase.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapperLowerCamel.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

