/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SubTypeValidator {
    protected static final String PREFIX_SPRING = "org.springframework.";
    protected static final String PREFIX_C3P0 = "com.mchange.v2.c3p0.";
    protected static final Set<String> DEFAULT_NO_DESER_CLASS_NAMES;
    protected Set<String> _cfgIllegalClassNames = DEFAULT_NO_DESER_CLASS_NAMES;
    private static final SubTypeValidator instance;

    protected SubTypeValidator() {
    }

    public static SubTypeValidator instance() {
        return instance;
    }

    public void validateSubType(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        String full;
        block6: {
            block7: {
                block8: {
                    Class<?> raw = type.getRawClass();
                    full = raw.getName();
                    if (this._cfgIllegalClassNames.contains(full)) break block6;
                    if (raw.isInterface()) break block7;
                    if (!full.startsWith(PREFIX_SPRING)) break block8;
                    for (Class<?> cls = raw; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                        String name = cls.getSimpleName();
                        if (!"AbstractPointcutAdvisor".equals(name) && !"AbstractApplicationContext".equals(name)) {
                            continue;
                        }
                        break block6;
                    }
                    break block7;
                }
                if (full.startsWith(PREFIX_C3P0) && full.endsWith("DataSource")) break block6;
            }
            return;
        }
        ctxt.reportBadTypeDefinition(beanDesc, "Illegal type (%s) to deserialize: prevented for security reasons", full);
    }

    static {
        HashSet<String> s2 = new HashSet<String>();
        s2.add("org.apache.commons.collections.functors.InvokerTransformer");
        s2.add("org.apache.commons.collections.functors.InstantiateTransformer");
        s2.add("org.apache.commons.collections4.functors.InvokerTransformer");
        s2.add("org.apache.commons.collections4.functors.InstantiateTransformer");
        s2.add("org.codehaus.groovy.runtime.ConvertedClosure");
        s2.add("org.codehaus.groovy.runtime.MethodClosure");
        s2.add("org.springframework.beans.factory.ObjectFactory");
        s2.add("com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl");
        s2.add("org.apache.xalan.xsltc.trax.TemplatesImpl");
        s2.add("com.sun.rowset.JdbcRowSetImpl");
        s2.add("java.util.logging.FileHandler");
        s2.add("java.rmi.server.UnicastRemoteObject");
        s2.add("org.springframework.beans.factory.config.PropertyPathFactoryBean");
        s2.add("org.apache.tomcat.dbcp.dbcp2.BasicDataSource");
        s2.add("com.sun.org.apache.bcel.internal.util.ClassLoader");
        s2.add("org.hibernate.jmx.StatisticsService");
        s2.add("org.apache.ibatis.datasource.jndi.JndiDataSourceFactory");
        DEFAULT_NO_DESER_CLASS_NAMES = Collections.unmodifiableSet(s2);
        instance = new SubTypeValidator();
    }
}

