/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import com.google.common.base.CaseFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class StringUtil {
    public static final String SEPARATOR = String.valueOf('\u001d');

    public static boolean isNotEmpty(String str) {
        return StringUtils.isNotEmpty(str);
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty(str);
    }

    public static String defaultIfEmpty(String str, String defaultValue) {
        return StringUtils.defaultIfEmpty(str, defaultValue);
    }

    public static String replaceAll(String str, String regex, String replacement) {
        Pattern p = Pattern.compile(regex);
        Matcher m3 = p.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (m3.find()) {
            m3.appendReplacement(sb, replacement);
        }
        m3.appendTail(sb);
        return sb.toString();
    }

    public static boolean isNumber(String str) {
        return NumberUtils.isCreatable(str);
    }

    public static boolean isDigits(String str) {
        return NumberUtils.isDigits(str);
    }

    public static String camelhumpToUnderline(String str) {
        Matcher matcher = Pattern.compile("[A-Z]").matcher(str);
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (matcher.find()) {
            builder.replace(matcher.start() + i, matcher.end() + i, "_" + matcher.group().toLowerCase());
            ++i;
        }
        if (builder.charAt(0) == '_') {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    public static String underlineToCamelhump(String str) {
        Matcher matcher = Pattern.compile("_[a-z]").matcher(str);
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (matcher.find()) {
            builder.replace(matcher.start() - i, matcher.end() - i, matcher.group().substring(1).toUpperCase());
            ++i;
        }
        if (Character.isUpperCase(builder.charAt(0))) {
            builder.replace(0, 1, String.valueOf(Character.toLowerCase(builder.charAt(0))));
        }
        return builder.toString();
    }

    public static String[] splitString(String str, String separator) {
        return StringUtils.splitByWholeSeparator(str, separator);
    }

    public static String firstToUpper(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String firstToLower(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String toPascalStyle(String str, String seperator) {
        return StringUtil.firstToUpper(StringUtil.toCamelhumpStyle(str, seperator));
    }

    public static String toCamelhumpStyle(String str, String seperator) {
        return StringUtil.underlineToCamelhump(StringUtil.toUnderlineStyle(str, seperator));
    }

    public static String toUnderlineStyle(String str, String seperator) {
        if ((str = str.trim().toLowerCase()).contains(seperator)) {
            str = str.replace(seperator, "_");
        }
        return str;
    }

    public static String toDisplayStyle(String str, String seperator) {
        String displayName = "";
        if ((str = str.trim().toLowerCase()).contains(seperator)) {
            String[] words;
            for (String word : words = StringUtil.splitString(str, seperator)) {
                displayName = displayName + StringUtil.firstToUpper(word) + " ";
            }
            displayName = displayName.trim();
        } else {
            displayName = StringUtil.firstToUpper(str);
        }
        return displayName;
    }

    public static String removeEndChar(String str) {
        if (!StringUtil.isEmpty(str)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String lower2UnLine(String lowerStr) {
        if (!StringUtils.isEmpty(lowerStr)) {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, lowerStr);
        }
        return lowerStr;
    }

    public static String unLine2Lower(String unLineStr) {
        if (!StringUtils.isEmpty(unLineStr)) {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, unLineStr);
        }
        return unLineStr;
    }
}

