/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.cachepkg;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class VPMapCache<K, V> {
    private boolean bIsStop = false;
    private ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    private DelayQueue<DelayedItem<K>> queue = new DelayQueue();

    public VPMapCache() {
        Thread t = new Thread(){

            @Override
            public void run() {
                VPMapCache.this.dameonCheckOverdueKey();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void destroy() {
        this.bIsStop = true;
    }

    public void put(K k, V v, long expiredTime) {
        V v2 = this.map.put(k, v);
        DelayedItem<K> tmpItem = new DelayedItem<K>(k, expiredTime <= 0L ? 1L : expiredTime);
        if (v2 != null) {
            try {
                this.queue.remove(tmpItem);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.queue.put(tmpItem);
    }

    public V get(K k) {
        return this.map.get(k);
    }

    private void dameonCheckOverdueKey() {
        while (!this.bIsStop) {
            DelayedItem delayedItem = (DelayedItem)this.queue.poll();
            if (delayedItem != null) {
                this.map.remove(delayedItem.getT());
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    class DelayedItem<T>
    implements Delayed {
        private T t;
        private long expiredAt;

        public DelayedItem(T t, long expiredTime) {
            this.setT(t);
            this.expiredAt = System.currentTimeMillis() + expiredTime;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expiredAt - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (o == null) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            long result = this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS);
            if (result < 0L) {
                return -1;
            }
            if (result > 0L) {
                return 1;
            }
            return 0;
        }

        public T getT() {
            return this.t;
        }

        public void setT(T t) {
            this.t = t;
        }

        public int hashCode() {
            return this.t.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof DelayedItem) {
                return object.hashCode() == this.hashCode();
            }
            return false;
        }
    }
}

