/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.delayqueue;

import com.global.base.delayqueue.DelayedItem;
import com.global.base.taskqueue.TaskQueueData;
import java.util.concurrent.DelayQueue;

public class DelayTaskQueue {
    private final DelayQueue<DelayedItem> mQueueDataForExe = new DelayQueue();

    public boolean isQueueEmpty() {
        return this.mQueueDataForExe.isEmpty() || this.getTaskCount() <= 0;
    }

    public int getTaskCount() {
        return this.mQueueDataForExe.size();
    }

    public boolean postQuitTask(boolean isClearTask) {
        if (isClearTask) {
            this.mQueueDataForExe.clear();
        }
        return this.mQueueDataForExe.offer(new DelayedItem(new TaskQueueData<String>(-1, "Quit"), 1L));
    }

    public <T> boolean postTaskData(int type, T data, long expiredMs) {
        return this.mQueueDataForExe.offer(new DelayedItem(new TaskQueueData<T>(type, data), expiredMs <= 0L ? 1L : expiredMs));
    }

    public boolean postTaskData(TaskQueueData taskData, long expiredMs) {
        if (taskData != null) {
            return this.mQueueDataForExe.offer(new DelayedItem(taskData, expiredMs <= 0L ? 1L : expiredMs));
        }
        return false;
    }

    public boolean postTaskData(TaskQueueData[] arrTaskData, long[] arrExpiredTime) {
        if (arrTaskData == null || arrExpiredTime == null || arrTaskData.length != arrExpiredTime.length) {
            return false;
        }
        for (int i = 0; i < arrTaskData.length; ++i) {
            if (arrTaskData[i] != null && this.mQueueDataForExe.offer(new DelayedItem(arrTaskData[i], arrExpiredTime[i] <= 0L ? 1L : arrExpiredTime[i]))) continue;
            return false;
        }
        return true;
    }

    public TaskQueueData getTaskData() {
        try {
            DelayedItem oItem = (DelayedItem)this.mQueueDataForExe.take();
            return oItem == null ? null : oItem.getData();
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    public TaskQueueData fastGetTaskData() {
        DelayedItem oItem = (DelayedItem)this.mQueueDataForExe.poll();
        return oItem == null ? null : oItem.getData();
    }
}

