/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class TraceIdUtil {
    private static ThreadLocal<String> mThreadLocal = new ThreadLocal();
    private static AtomicInteger mTraceCreator = new AtomicInteger(1);
    private static final String DEFAULT_TRACE_ID = "TID-0";
    private static final long TM_RUN = System.currentTimeMillis() / 1000L;

    public static void setTraceId(String traceId) {
        try {
            mThreadLocal.set(StringUtils.isEmpty((CharSequence)traceId) ? DEFAULT_TRACE_ID : traceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setTraceIdByBusinessType(String strBusinessType) {
        try {
            mThreadLocal.set("TID-" + TraceIdUtil.genTraceId(strBusinessType));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getTraceId() {
        String strRes = "";
        try {
            strRes = mThreadLocal.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return StringUtils.isEmpty((CharSequence)strRes) ? DEFAULT_TRACE_ID : strRes;
    }

    public static String removeTraceId() {
        String strRes = TraceIdUtil.getTraceId();
        try {
            mThreadLocal.remove();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strRes;
    }

    private static String genTraceId(String strBusinessType) {
        if (StringUtils.isEmpty((CharSequence)strBusinessType)) {
            return String.format("NO-%d.%d-%d", TM_RUN, mTraceCreator.getAndIncrement(), Thread.currentThread().getId());
        }
        return String.format("%s-%d.%d-%d", strBusinessType, TM_RUN, mTraceCreator.getAndIncrement(), Thread.currentThread().getId());
    }
}

