/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.log;

import com.global.base.log.LogInfoData;
import com.global.base.log.LogLevelFlag;
import com.global.base.log.LogPrintMgr;
import com.global.base.taskqueue.BaseTaskQueueHandler;
import com.global.base.taskqueue.TaskQueueData;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTaskQueueHandler
extends BaseTaskQueueHandler {
    private final Logger mLogger = LoggerFactory.getLogger(this.getClass());
    private String mStrClassName;
    private AtomicBoolean mStartedRun = new AtomicBoolean(false);

    public LogTaskQueueHandler() {
        this(0);
    }

    public LogTaskQueueHandler(int nID) {
        this.mStrClassName = String.format("%s(ID:%d)", this.getClass().getSimpleName(), nID);
    }

    public boolean isRunning() {
        return this.mStartedRun != null && this.mStartedRun.get();
    }

    @Override
    public void run() {
        TaskQueueData taskData = null;
        boolean bExeOk = true;
        this.mStartedRun.set(true);
        block7: while (true) {
            try {
                while (true) {
                    if (!bExeOk && taskData != null) {
                        if (!taskData.subAndCheckEnd()) {
                            this.postTaskData(taskData);
                        }
                        taskData = null;
                    }
                    bExeOk = false;
                    taskData = this.getTaskData();
                    if (taskData == null) continue;
                    if (taskData.getType() == -1) break block7;
                    LogInfoData infoData = (LogInfoData)taskData.getData();
                    if (infoData != null) {
                        switch (infoData.getmNLevel()) {
                            case LOG_INFO: {
                                if (LogPrintMgr.getInstance().getPrintSink() != null) {
                                    LogPrintMgr.getInstance().getPrintSink().printLogMsg(LogLevelFlag.LOG_INFO.ordinal(), infoData.getmStrMsg());
                                    break;
                                }
                                this.mLogger.info(infoData.getmStrMsg());
                                break;
                            }
                            case LOG_WARN: {
                                if (LogPrintMgr.getInstance().getPrintSink() != null) {
                                    LogPrintMgr.getInstance().getPrintSink().printLogMsg(LogLevelFlag.LOG_WARN.ordinal(), infoData.getmStrMsg());
                                    break;
                                }
                                this.mLogger.warn(infoData.getmStrMsg());
                                break;
                            }
                            case LOG_ERROR: {
                                if (LogPrintMgr.getInstance().getPrintSink() != null) {
                                    LogPrintMgr.getInstance().getPrintSink().printLogMsg(LogLevelFlag.LOG_ERROR.ordinal(), infoData.getmStrMsg());
                                    break;
                                }
                                this.mLogger.error(infoData.getmStrMsg());
                                break;
                            }
                        }
                    }
                    bExeOk = true;
                    taskData = null;
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        this.mStartedRun.set(false);
    }
}

