/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.taskqueue;

import com.global.base.taskqueue.TaskQueueData;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class TaskQueue {
    private final BlockingQueue<TaskQueueData> mQueueDataForExe;

    public TaskQueue() {
        this.mQueueDataForExe = new LinkedBlockingQueue<TaskQueueData>();
    }

    public TaskQueue(int capacity) {
        this.mQueueDataForExe = new LinkedBlockingQueue<TaskQueueData>(capacity);
    }

    public boolean isQueueEmpty() {
        return this.mQueueDataForExe.isEmpty() || this.getTaskCount() <= 0;
    }

    public int getTaskCount() {
        return this.mQueueDataForExe.size();
    }

    public boolean postQuitTask(boolean isClearTask) {
        if (isClearTask) {
            this.mQueueDataForExe.clear();
        }
        return this.mQueueDataForExe.offer(new TaskQueueData<String>(-1, "Quit"));
    }

    public <T> boolean postTaskData(int type, T data) {
        return this.mQueueDataForExe.offer(new TaskQueueData<T>(type, data));
    }

    public boolean postTaskData(TaskQueueData taskData) {
        if (taskData != null) {
            return this.mQueueDataForExe.offer(taskData);
        }
        return false;
    }

    public boolean postTaskData(TaskQueueData[] arrTaskData) {
        for (int i = 0; i < arrTaskData.length; ++i) {
            if (arrTaskData[i] != null && this.mQueueDataForExe.offer(arrTaskData[i])) continue;
            return false;
        }
        return true;
    }

    public TaskQueueData getTaskData() {
        try {
            return this.mQueueDataForExe.take();
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    public TaskQueueData fastGetTaskData() {
        return (TaskQueueData)this.mQueueDataForExe.poll();
    }
}

