/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.httpclient;

import com.global.base.httpclient.HttpTrustManager;
import com.global.base.httpclient.HttpVerifyHostname;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.CodingErrorAction;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Consts;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.ssl.SSLContexts;

public class HttpAsyncClient {
    private int socketTimeout = 20000;
    private int connectTimeout = 10000;
    private int connReqestTimeout = 5000;
    private static final int poolSize = 3000;
    private static final int maxPerRoute = 1000;
    private boolean mBHttpsPostWithCert = false;
    private boolean mBVerifySvrCert = false;
    private String mStrLocalKeyPass = "Nr12345678";
    private String mStrLocalKeyPath = "./nengry.pfx";
    private String mStrSvrCertDir = "";
    private int mNCpuCores = 1;
    private CloseableHttpAsyncClient asyncHttpClient = null;
    private String credentUsername = "";
    private String credentPassword = "";

    public HttpAsyncClient(int nSockTime, int nConnTime, int cpuCores, boolean bPostWithCert, boolean bVerifySvrCert, String strSvrCertDir, String strLocalKeyPass, String strLocalKeyPath) {
        this.mNCpuCores = cpuCores;
        this.socketTimeout = nSockTime;
        this.connectTimeout = nConnTime;
        this.mBHttpsPostWithCert = bPostWithCert;
        this.mBVerifySvrCert = bVerifySvrCert;
        this.mStrSvrCertDir = strSvrCertDir;
        try {
            this.asyncHttpClient = this.createAsyncClient();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (bPostWithCert) {
            this.mStrLocalKeyPath = strLocalKeyPath;
            this.mStrLocalKeyPass = strLocalKeyPass;
        }
    }

    public HttpAsyncClient() {
        this(20000, 10000, 1, false, false, "", "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private CloseableHttpAsyncClient createAsyncClient() throws Exception {
        SSLContext sslcontext;
        RequestConfig requestConfig;
        block15: {
            block16: {
                requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setConnectionRequestTimeout(this.connReqestTimeout).build();
                sslcontext = null;
                if (!this.mBHttpsPostWithCert) break block16;
                FileInputStream inStream = null;
                KeyStore keyStore = null;
                keyStore = KeyStore.getInstance("PKCS12");
                inStream = new FileInputStream(new File(this.mStrLocalKeyPath));
                keyStore.load(inStream, this.mStrLocalKeyPass.toCharArray());
                sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, new TrustSelfSignedStrategy()).build();
                System.out.println("keyStore.load success...");
                try {
                    inStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (sslcontext == null) {
                    sslcontext = SSLContexts.createDefault();
                    sslcontext.init(null, new TrustManager[]{new HttpTrustManager(this.mBVerifySvrCert, this.mStrSvrCertDir)}, new SecureRandom());
                }
                break block15;
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e2222222222) {
                    try {
                        e2222222222.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            inStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (sslcontext == null) {
                            sslcontext = SSLContexts.createDefault();
                            sslcontext.init(null, new TrustManager[]{new HttpTrustManager(this.mBVerifySvrCert, this.mStrSvrCertDir)}, new SecureRandom());
                        }
                        throw throwable;
                    }
                    try {
                        inStream.close();
                    }
                    catch (IOException e2222222222) {
                        // empty catch block
                    }
                    if (sslcontext == null) {
                        sslcontext = SSLContexts.createDefault();
                        sslcontext.init(null, new TrustManager[]{new HttpTrustManager(this.mBVerifySvrCert, this.mStrSvrCertDir)}, new SecureRandom());
                    }
                    break block15;
                }
            }
            sslcontext = SSLContexts.createDefault();
            sslcontext.init(null, new TrustManager[]{new HttpTrustManager(this.mBVerifySvrCert, this.mStrSvrCertDir)}, new SecureRandom());
        }
        SSLIOSessionStrategy sslioSessionStrategy = new SSLIOSessionStrategy(sslcontext, new HttpVerifyHostname());
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.credentUsername, this.credentPassword);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, credentials);
        Registry<SchemeIOSessionStrategy> sessionStrategyRegistry = RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)sslioSessionStrategy)).build();
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoKeepAlive(false).setTcpNoDelay(true).setIoThreadCount(this.mNCpuCores * 2).build();
        DefaultConnectingIOReactor ioReactor = null;
        try {
            ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        }
        catch (IOReactorException e) {
            e.printStackTrace();
        }
        PoolingNHttpClientConnectionManager conMgr = new PoolingNHttpClientConnectionManager(ioReactor, null, sessionStrategyRegistry, null);
        conMgr.setMaxTotal(3000);
        conMgr.setDefaultMaxPerRoute(1000);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
        Registry<AuthSchemeProvider> authSchemeRegistry = RegistryBuilder.create().register("Basic", new BasicSchemeFactory()).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory())).register("NTLM", (BasicSchemeFactory)((Object)new NTLMSchemeFactory())).register("Negotiate", (BasicSchemeFactory)((Object)new SPNegoSchemeFactory())).register("Kerberos", (BasicSchemeFactory)((Object)new KerberosSchemeFactory())).build();
        conMgr.setDefaultConnectionConfig(connectionConfig);
        return HttpAsyncClients.custom().setConnectionManager(conMgr).setDefaultCredentialsProvider(credentialsProvider).setDefaultAuthSchemeRegistry(authSchemeRegistry).setDefaultRequestConfig(requestConfig).setDefaultCookieStore(new BasicCookieStore()).build();
    }

    public CloseableHttpAsyncClient getAsyncHttpClient() {
        return this.asyncHttpClient;
    }
}

