/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.log;

import com.global.base.log.LogInfoData;
import com.global.base.log.LogTaskQueueHandler;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class LogTaskQueueHandlerPool {
    private static volatile LogTaskQueueHandlerPool msInstance = null;
    private String mStrClassName = this.getClass().getSimpleName();
    private volatile int mPoolSize = 1;
    private AtomicInteger mCurPoolIndex = null;
    private volatile boolean mBInited = false;
    private CopyOnWriteArrayList<LogTaskQueueHandler> arrHandlers = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogTaskQueueHandlerPool getInstance() {
        if (msInstance != null) return msInstance;
        Class<LogTaskQueueHandlerPool> clazz = LogTaskQueueHandlerPool.class;
        synchronized (LogTaskQueueHandlerPool.class) {
            if (msInstance != null) return msInstance;
            msInstance = new LogTaskQueueHandlerPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return msInstance;
        }
    }

    private LogTaskQueueHandlerPool() {
    }

    public boolean isInited() {
        return this.mBInited;
    }

    public void init(int poolSize) {
        if (!this.mBInited) {
            this.mBInited = true;
            this.mPoolSize = poolSize < 1 ? 1 : poolSize;
            this.mCurPoolIndex = new AtomicInteger(0);
            this.arrHandlers = new CopyOnWriteArrayList();
            for (int i = 0; i < this.mPoolSize; ++i) {
                LogTaskQueueHandler handler = new LogTaskQueueHandler(i);
                this.arrHandlers.add(handler);
                new Thread(handler).start();
            }
            this.mPoolSize = this.arrHandlers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogTaskQueueHandler getTaskQueueHandler() {
        LogTaskQueueHandler handler = null;
        if (!this.arrHandlers.isEmpty()) {
            int nNext = 0;
            try {
                nNext = this.mCurPoolIndex.getAndIncrement() % this.mPoolSize;
                handler = this.arrHandlers.get(nNext);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (handler == null) {
                LogTaskQueueHandlerPool logTaskQueueHandlerPool = this;
                synchronized (logTaskQueueHandlerPool) {
                    if (nNext < this.mPoolSize) {
                        try {
                            handler = this.arrHandlers.get(nNext);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (handler == null) {
                            LogTaskQueueHandler newHandler = new LogTaskQueueHandler(this.mPoolSize);
                            new Thread(newHandler).start();
                            this.arrHandlers.set(nNext, newHandler);
                            this.mPoolSize = this.arrHandlers.size();
                        }
                    }
                }
                try {
                    handler = this.arrHandlers.get(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (handler == null || !handler.isRunning()) {
                return null;
            }
        }
        return handler;
    }

    public void stopAllQueueHandler(boolean isClearTask) {
        for (LogTaskQueueHandler oHandler : this.arrHandlers) {
            oHandler.quitTaskQueue(isClearTask);
        }
        this.arrHandlers.clear();
    }

    public void timePerSecondNow() {
        for (LogTaskQueueHandler oHandler : this.arrHandlers) {
            oHandler.timePerSecondNow();
        }
    }

    public boolean postTaskData(LogInfoData infoData) {
        LogTaskQueueHandler handler;
        if (infoData != null && (handler = this.getTaskQueueHandler()) != null) {
            return handler.postTaskData(-2, infoData);
        }
        return false;
    }
}

