/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.thread;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class ThreadPoolProxy {
    private static volatile ThreadPoolProxy msInstance = null;
    private AtomicInteger threadIndex = new AtomicInteger(0);
    private ExecutorService mCachedThreadPool = null;
    private ExecutorService mSingleThreadPool = null;
    private ConcurrentHashMap<String, ExecutorService> mMapFixedThreadPool = new ConcurrentHashMap();

    private ThreadPoolProxy() {
        this.mCachedThreadPool = Executors.newCachedThreadPool();
        this.mSingleThreadPool = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolProxy getInstance() {
        if (msInstance != null) return msInstance;
        Class<ThreadPoolProxy> clazz = ThreadPoolProxy.class;
        synchronized (ThreadPoolProxy.class) {
            if (msInstance != null) return msInstance;
            msInstance = new ThreadPoolProxy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return msInstance;
        }
    }

    public void initFixedPoolRes(String strPoolKeyName, int nThreadCounts) {
        this.initFixedPoolRes(strPoolKeyName, nThreadCounts, "ComGlobalBase");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initFixedPoolRes(String strPoolKeyName, int nThreadCounts, final String strThreadPrefixName) {
        if (StringUtils.isEmpty((CharSequence)strPoolKeyName) || this.mMapFixedThreadPool.get(strPoolKeyName) != null) return;
        Class<ThreadPoolProxy> clazz = ThreadPoolProxy.class;
        synchronized (ThreadPoolProxy.class) {
            if (this.mMapFixedThreadPool.get(strPoolKeyName) != null) return;
            ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(nThreadCounts <= 0 ? 100 : nThreadCounts, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, strThreadPrefixName + "-" + ThreadPoolProxy.this.threadIndex.incrementAndGet());
                    t.setDaemon(true);
                    return t;
                }
            });
            this.mMapFixedThreadPool.put(strPoolKeyName, newFixedThreadPool);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public ExecutorService getCachedThreadPool() {
        return this.mCachedThreadPool;
    }

    public ExecutorService getSingleThreadPool() {
        return this.mSingleThreadPool;
    }

    public ExecutorService getFixedThreadPool(String strPoolKeyName) {
        ExecutorService subObj = null;
        if (StringUtils.isEmpty((CharSequence)strPoolKeyName)) {
            return subObj;
        }
        subObj = this.mMapFixedThreadPool.get(strPoolKeyName);
        if (subObj == null) {
            this.initFixedPoolRes(strPoolKeyName, 100);
            subObj = this.mMapFixedThreadPool.get(strPoolKeyName);
        }
        return subObj;
    }
}

