/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.delayqueue;

import com.global.base.taskqueue.TaskQueueData;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedItem
implements Delayed {
    private TaskQueueData data;
    private long expiredAt;

    public DelayedItem(TaskQueueData data, long expiredTime) {
        this.data = data;
        this.expiredAt = System.currentTimeMillis() + expiredTime;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expiredAt - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        long result = this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS);
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }

    public TaskQueueData getData() {
        return this.data;
    }

    public void setData(TaskQueueData data) {
        this.data = data;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DelayedItem) {
            return object.hashCode() == this.hashCode();
        }
        return false;
    }
}

