/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.httpclient;

import com.global.base.httpclient.HttpBackResponse;
import com.global.base.httpclient.HttpClientFactory;
import com.global.base.httpclient.HttpDeleteWithBody;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.http.util.TextUtils;

public class HttpClientMgr {
    private static final String UTF8CHARSET = "UTF-8";
    private static final String CONTENT_TYPE = "application/json";

    public static boolean httpAsyncRequest(METHOD emMethod, String baseUrl, String strBody, String urlParams, Map<String, String> mapHeads, HttpBackResponse callback) throws Exception {
        if (emMethod == METHOD.GET) {
            return HttpClientMgr.httpAsyncGet(baseUrl, urlParams, mapHeads, callback);
        }
        if (TextUtils.isEmpty(baseUrl)) {
            throw new Exception("missing base url");
        }
        try {
            CloseableHttpAsyncClient hc = HttpClientFactory.getInstance().getHttpAsyncClientPool().getAsyncHttpClient();
            if (hc != null) {
                hc.start();
                HttpEntityEnclosingRequestBase httpRequest = null;
                httpRequest = emMethod == METHOD.DELETE ? new HttpDeleteWithBody(baseUrl) : (emMethod == METHOD.PUT ? new HttpPut(baseUrl) : new HttpPost(baseUrl));
                httpRequest.setHeader("Connection", "close");
                if (!TextUtils.isEmpty(strBody)) {
                    StringEntity entity = new StringEntity(strBody, UTF8CHARSET);
                    entity.setContentEncoding(UTF8CHARSET);
                    entity.setContentType(CONTENT_TYPE);
                    httpRequest.setEntity(entity);
                }
                if (!TextUtils.isEmpty(urlParams)) {
                    httpRequest.setURI(new URI(httpRequest.getURI().toString() + "?" + urlParams));
                }
                if (mapHeads != null) {
                    for (Map.Entry<String, String> entry : mapHeads.entrySet()) {
                        String strHeadKey = entry.getKey();
                        String strHeadValue = entry.getValue();
                        if (TextUtils.isEmpty(strHeadKey)) continue;
                        httpRequest.setHeader(strHeadKey, strHeadValue);
                    }
                }
                hc.execute(httpRequest, callback);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean httpAsyncRequest(METHOD emMethod, String baseUrl, List<BasicNameValuePair> listBody, List<BasicNameValuePair> urlParams, Map<String, String> mapHeads, HttpBackResponse callback) throws Exception {
        if (emMethod == METHOD.GET) {
            return HttpClientMgr.httpAsyncGet(baseUrl, urlParams, mapHeads, callback);
        }
        if (TextUtils.isEmpty(baseUrl)) {
            throw new Exception("missing base url");
        }
        try {
            CloseableHttpAsyncClient hc = HttpClientFactory.getInstance().getHttpAsyncClientPool().getAsyncHttpClient();
            if (hc != null) {
                hc.start();
                HttpEntityEnclosingRequestBase httpRequest = null;
                httpRequest = emMethod == METHOD.DELETE ? new HttpDeleteWithBody(baseUrl) : (emMethod == METHOD.PUT ? new HttpPut(baseUrl) : new HttpPost(baseUrl));
                httpRequest.setHeader("Connection", "close");
                if (null != listBody) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(listBody, UTF8CHARSET);
                    entity.setContentEncoding(UTF8CHARSET);
                    entity.setContentType(CONTENT_TYPE);
                    httpRequest.setEntity(entity);
                }
                if (null != urlParams) {
                    String getUrl = EntityUtils.toString(new UrlEncodedFormEntity(urlParams, UTF8CHARSET));
                    httpRequest.setURI(new URI(httpRequest.getURI().toString() + "?" + getUrl));
                }
                if (null != mapHeads) {
                    for (Map.Entry<String, String> entry : mapHeads.entrySet()) {
                        String strHeadKey = entry.getKey();
                        String strHeadValue = entry.getValue();
                        if (TextUtils.isEmpty(strHeadKey)) continue;
                        httpRequest.setHeader(strHeadKey, strHeadValue);
                    }
                }
                hc.execute(httpRequest, callback);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean httpAsyncGet(String baseUrl, String urlParams, Map<String, String> mapHeads, HttpBackResponse callback) throws Exception {
        if (TextUtils.isEmpty(baseUrl)) {
            throw new Exception("missing base url");
        }
        try {
            CloseableHttpAsyncClient hc = HttpClientFactory.getInstance().getHttpAsyncClientPool().getAsyncHttpClient();
            if (hc != null) {
                hc.start();
                HttpGet httpGet = new HttpGet(baseUrl);
                httpGet.setHeader("Connection", "close");
                if (!TextUtils.isEmpty(urlParams)) {
                    httpGet.setURI(new URI(httpGet.getURI().toString() + "?" + urlParams));
                }
                if (mapHeads != null) {
                    for (Map.Entry<String, String> entry : mapHeads.entrySet()) {
                        String strHeadKey = entry.getKey();
                        String strHeadValue = entry.getValue();
                        if (TextUtils.isEmpty(strHeadKey)) continue;
                        httpGet.setHeader(strHeadKey, strHeadValue);
                    }
                }
                hc.execute(httpGet, callback);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean httpAsyncGet(String baseUrl, List<BasicNameValuePair> urlParams, Map<String, String> mapHeads, HttpBackResponse callback) throws Exception {
        if (TextUtils.isEmpty(baseUrl)) {
            throw new Exception("missing base url");
        }
        try {
            CloseableHttpAsyncClient hc = HttpClientFactory.getInstance().getHttpAsyncClientPool().getAsyncHttpClient();
            if (hc != null) {
                hc.start();
                HttpGet httpGet = new HttpGet(baseUrl);
                httpGet.setHeader("Connection", "close");
                if (null != urlParams) {
                    String getUrl = EntityUtils.toString(new UrlEncodedFormEntity(urlParams, UTF8CHARSET));
                    httpGet.setURI(new URI(httpGet.getURI().toString() + "?" + getUrl));
                }
                if (null != mapHeads) {
                    for (Map.Entry<String, String> entry : mapHeads.entrySet()) {
                        String strHeadKey = entry.getKey();
                        String strHeadValue = entry.getValue();
                        if (TextUtils.isEmpty(strHeadKey)) continue;
                        httpGet.setHeader(strHeadKey, strHeadValue);
                    }
                }
                hc.execute(httpGet, callback);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static enum METHOD {
        POST,
        GET,
        DELETE,
        PUT;

    }
}

