/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import com.global.base.tools.RandomUtil;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtil {
    private static final Charset CHARSET_U8 = Charset.forName("UTF-8");
    private static final String CHARSET_U8_STR = "UTF-8";

    private static String encrypt(Mode aesMode, Padding padding, String secretKey, String ivKey, String content) {
        String encryptMode = "AES/" + aesMode.toStrValue() + "/" + padding.toStrValue();
        String encryptContent = null;
        try {
            String encyptType = encryptMode;
            switch (padding) {
                case NO_PADDING: {
                    int len = content.getBytes(CHARSET_U8_STR).length;
                    int m3 = len % 16;
                    if (m3 == 0) break;
                    for (int i = 0; i < 16 - m3; ++i) {
                        content = content + " ";
                    }
                    break;
                }
                case ZERO_PADDING: {
                    throw new IllegalArgumentException("Not Support:" + Padding.ZERO_PADDING.toStrValue());
                }
                case PKCS7_PADDING: {
                    Security.addProvider(new BouncyCastleProvider());
                    break;
                }
            }
            SecretKeySpec keyspec = new SecretKeySpec(secretKey.getBytes(CHARSET_U8), "AES");
            Cipher cipher = Cipher.getInstance(encyptType);
            switch (aesMode) {
                case ECB: {
                    cipher.init(1, keyspec);
                    break;
                }
                default: {
                    IvParameterSpec iv = new IvParameterSpec(ivKey.getBytes(CHARSET_U8));
                    cipher.init(1, (Key)keyspec, iv);
                }
            }
            byte[] byte_encode = content.getBytes(CHARSET_U8_STR);
            byte_encode = cipher.doFinal(byte_encode);
            encryptContent = new String(Base64.encodeBase64((byte[])byte_encode));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptContent;
    }

    private static String decrypt(Mode aesMode, Padding padding, String secretKey, String ivKey, String content) {
        String encryptMode = "AES/" + aesMode.toStrValue() + "/" + padding.toStrValue();
        String decryptContent = null;
        try {
            String encyptType = encryptMode;
            switch (padding) {
                case NO_PADDING: {
                    int len = content.getBytes(CHARSET_U8_STR).length;
                    int m3 = len % 16;
                    if (m3 == 0) break;
                    for (int i = 0; i < 16 - m3; ++i) {
                        content = content + " ";
                    }
                    break;
                }
                case ZERO_PADDING: {
                    throw new IllegalArgumentException("Not Support:" + Padding.ZERO_PADDING.toStrValue());
                }
                case PKCS7_PADDING: {
                    Security.addProvider(new BouncyCastleProvider());
                    break;
                }
            }
            SecretKeySpec keyspec = new SecretKeySpec(secretKey.getBytes(CHARSET_U8), "AES");
            Cipher cipher = Cipher.getInstance(encyptType);
            switch (aesMode) {
                case ECB: {
                    cipher.init(2, keyspec);
                    break;
                }
                default: {
                    IvParameterSpec iv = new IvParameterSpec(ivKey.getBytes(CHARSET_U8));
                    cipher.init(2, (Key)keyspec, iv);
                }
            }
            byte[] byte_content = Base64.decodeBase64((String)content);
            byte_content = cipher.doFinal(byte_content);
            decryptContent = new String(byte_content, CHARSET_U8_STR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptContent;
    }

    public static String AESEncrypt(Mode aesMode, Padding padding, String key, String content) {
        return AESUtil.encrypt(aesMode, padding, key, StringUtils.length((CharSequence)key) != 16 ? RandomUtil.getRandomStr(16).toUpperCase() : key, content);
    }

    public static String AESDecrypt(Mode aesMode, Padding padding, String key, String content) {
        return AESUtil.decrypt(aesMode, padding, key, StringUtils.length((CharSequence)key) != 16 ? RandomUtil.getRandomStr(16).toUpperCase() : key, content);
    }

    public static enum Padding {
        NO_PADDING(0, "NoPadding"),
        ZERO_PADDING(1, "ZeroPadding"),
        PKCS5_PADDING(2, "PKCS5Padding"),
        PKCS7_PADDING(3, "PKCS7Padding"),
        ISO10126Padding(4, "ISO10126Padding");

        private String name;
        private int index;

        private Padding(int index, String name) {
            this.name = name;
            this.index = index;
        }

        public int toIntValue() {
            return this.index;
        }

        public String toStrValue() {
            return this.name;
        }
    }

    public static enum Mode {
        CBC(0, "CBC"),
        ECB(1, "ECB"),
        CFB(2, "CFB"),
        CTR(3, "CTR"),
        OFB(4, "OFB");

        private String name;
        private int index;

        private Mode(int index, String name) {
            this.name = name;
            this.index = index;
        }

        public int toIntValue() {
            return this.index;
        }

        public String toStrValue() {
            return this.name;
        }
    }
}

