/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import com.global.base.dto.TreeNodeEx;
import java.util.ArrayList;
import java.util.List;

public class TreeNodeUtil {
    public static List<TreeNodeEx> initAndSortNodes(List<? extends TreeNodeEx> srcData, boolean isExpand) {
        ArrayList<TreeNodeEx> result = new ArrayList<TreeNodeEx>();
        List<? extends TreeNodeEx> nodes = TreeNodeUtil.convertData2Node(srcData);
        List<TreeNodeEx> rootNodes = TreeNodeUtil.getRootNodes(nodes);
        for (TreeNodeEx node : rootNodes) {
            TreeNodeUtil.addNode(result, node, isExpand);
        }
        return result;
    }

    public static void getChildNodes(TreeNodeEx node, List<TreeNodeEx> listRes, int minLevel, int maxLevel) {
        if (node != null && listRes == null) {
            return;
        }
        if (maxLevel < minLevel) {
            maxLevel = minLevel;
        }
        if (maxLevel <= 0) {
            return;
        }
        int nSelfLevel = node.getLevel();
        int realMinL = nSelfLevel + minLevel;
        int realMaxL = nSelfLevel + maxLevel;
        List<TreeNodeEx> arrLeaf = node.getChildren();
        if (arrLeaf != null) {
            for (TreeNodeEx oChild : arrLeaf) {
                if (oChild.getLevel() >= realMinL && oChild.getLevel() <= realMaxL) {
                    listRes.add(oChild);
                }
                if (oChild.isLeaf()) continue;
                TreeNodeUtil.getChildNodes(oChild, listRes, minLevel - 1, maxLevel - 1);
            }
        }
    }

    public static void getParentNodes(TreeNodeEx node, List<TreeNodeEx> listRes, int minLevel, int maxLevel) {
        if (node != null && listRes == null) {
            return;
        }
        if (maxLevel < minLevel) {
            maxLevel = minLevel;
        }
        if (maxLevel <= 0) {
            return;
        }
        int nSelfLevel = node.getLevel();
        int realMaxL = nSelfLevel - minLevel;
        int realMinL = nSelfLevel - maxLevel;
        TreeNodeEx parent = node.getParent();
        if (parent != null) {
            if (parent.getLevel() >= realMinL && parent.getLevel() <= realMaxL) {
                listRes.add(parent);
            }
            TreeNodeUtil.getParentNodes(parent, listRes, minLevel - 1, maxLevel - 1);
        }
    }

    public static void getParentNodes(TreeNodeEx node, List<TreeNodeEx> listRes, boolean bFirstP) {
        if (node != null && listRes == null) {
            return;
        }
        TreeNodeEx parent = node.getParent();
        if (parent != null) {
            listRes.add(parent);
            if (!bFirstP) {
                TreeNodeUtil.getParentNodes(parent, listRes, bFirstP);
            }
        }
    }

    private static List<? extends TreeNodeEx> convertData2Node(List<? extends TreeNodeEx> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            TreeNodeEx n = nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                TreeNodeEx m3 = nodes.get(j);
                if (m3.getpId() instanceof String) {
                    if (m3.getpId().equals(n.getId())) {
                        n.getChildren().add(m3);
                        m3.setParent(n);
                        continue;
                    }
                    if (!m3.getId().equals(n.getpId())) continue;
                    m3.getChildren().add(n);
                    n.setParent(m3);
                    continue;
                }
                if (m3.getpId() == n.getId()) {
                    n.getChildren().add(m3);
                    m3.setParent(n);
                    continue;
                }
                if (m3.getId() != n.getpId()) continue;
                m3.getChildren().add(n);
                n.setParent(m3);
            }
        }
        return nodes;
    }

    private static List<TreeNodeEx> getRootNodes(List<? extends TreeNodeEx> nodes) {
        ArrayList<TreeNodeEx> root = new ArrayList<TreeNodeEx>();
        for (TreeNodeEx treeNodeEx : nodes) {
            if (!treeNodeEx.isRoot()) continue;
            root.add(treeNodeEx);
        }
        return root;
    }

    private static <T, B> void addNode(List<TreeNodeEx> result, TreeNodeEx<T, B> node, boolean isExpand) {
        node.setExpand(isExpand);
        result.add(node);
        if (node.isLeaf()) {
            return;
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            TreeNodeUtil.addNode(result, node.getChildren().get(i), isExpand);
        }
    }
}

