/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.httpclient;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class HttpTrustManager
implements X509TrustManager {
    private boolean mBVerifySvrCert = false;
    private List<String> arrCertFilePath = null;
    private List<Certificate> arrSvrCert = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpTrustManager(boolean bVerifySvrCert, String strServerCertDir) {
        this.mBVerifySvrCert = bVerifySvrCert;
        if (this.mBVerifySvrCert) {
            this.arrCertFilePath = new ArrayList<String>();
            this.arrSvrCert = new ArrayList<Certificate>();
            this.getCertFileList(strServerCertDir);
            for (String strCertPath : this.arrCertFilePath) {
                Certificate cert = null;
                try {
                    FileInputStream fis = new FileInputStream(strCertPath);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    while (bis.available() > 0) {
                        cert = cf.generateCertificate(bis);
                    }
                    bis.close();
                    if (cert == null) continue;
                    this.arrSvrCert.add(cert);
                }
                catch (IOException | CertificateException e) {
                    e.printStackTrace();
                }
                finally {
                    if (cert != null) {
                        this.arrSvrCert.add(cert);
                    }
                }
            }
        }
    }

    private void getCertFileList(String strDir) {
        try {
            File f = new File(strDir);
            if (f.isDirectory()) {
                File[] fs = f.listFiles();
                for (int i = 0; i < fs.length; ++i) {
                    String fsPath = fs[i].getCanonicalPath();
                    this.getCertFileList(fsPath);
                }
            } else if (f.isFile() && (f.getName().endsWith(".cer") || f.getName().endsWith(".crt") || f.getName().endsWith(".der") || f.getName().endsWith(".p12") || f.getName().endsWith(".pem"))) {
                this.arrCertFilePath.add(f.getCanonicalPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String s2) throws CertificateException {
        if (!this.mBVerifySvrCert || this.arrSvrCert == null || this.arrSvrCert.size() <= 0) {
            return;
        }
        if (chain == null) {
            return;
        }
        for (X509Certificate certRecv : chain) {
            for (Certificate certLocal : this.arrSvrCert) {
                if (!certRecv.toString().equals(certLocal.toString())) continue;
                return;
            }
        }
        throw new CertificateException("certificate is illegal");
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

