/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptionUtil {
    private static final String DES_FLAG = "DES";
    private static final String DES3_FLAG = "DESede";
    private static final Map<String, String> msMapDES2Mode = new HashMap<String, String>();
    public static final char[] HEX_DIGITS;

    private static SecretKey buildDesKey(String keyStr, String modeFlag) throws Exception {
        if (DES3_FLAG.equals(modeFlag)) {
            byte[] key = new byte[24];
            byte[] temp = (keyStr == null || keyStr.isEmpty() ? "12345678" : keyStr).getBytes();
            if (key.length > temp.length) {
                System.arraycopy(temp, 0, key, 0, temp.length);
            } else {
                System.arraycopy(temp, 0, key, 0, key.length);
            }
            return new SecretKeySpec(key, modeFlag);
        }
        DESKeySpec keySpec = new DESKeySpec((keyStr == null || keyStr.isEmpty() ? "12345678" : keyStr).getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(modeFlag);
        return keyFactory.generateSecret(keySpec);
    }

    private static String encodeDes(String key, String srcStr, String modeFlag) {
        try {
            byte[] srcByte = srcStr.getBytes();
            SecretKey desKey = EncryptionUtil.buildDesKey(key, modeFlag);
            Cipher c1 = Cipher.getInstance(msMapDES2Mode.get(modeFlag));
            if (DES3_FLAG.equals(modeFlag)) {
                c1.init(1, desKey);
            } else {
                c1.init(1, (Key)desKey, new SecureRandom());
            }
            return Base64.encodeBase64String((byte[])c1.doFinal(srcByte));
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchPaddingException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return "";
    }

    private static String decodeDes(String key, String desStr, String modeFlag) {
        try {
            byte[] desByte = Base64.decodeBase64((String)desStr);
            SecretKey desKey = EncryptionUtil.buildDesKey(key, modeFlag);
            Cipher c1 = Cipher.getInstance(msMapDES2Mode.get(modeFlag));
            if (DES3_FLAG.equals(modeFlag)) {
                c1.init(2, desKey);
            } else {
                c1.init(2, (Key)desKey, new SecureRandom());
            }
            return new String(c1.doFinal(desByte));
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchPaddingException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return "";
    }

    public static String getHash(String source, String hashType) {
        try {
            MessageDigest md = MessageDigest.getInstance(hashType);
            byte[] bytes = md.digest(source.getBytes("utf-8"));
            StringBuilder ret = new StringBuilder(bytes.length * 2);
            for (int i = 0; i < bytes.length; ++i) {
                ret.append(HEX_DIGITS[bytes[i] >> 4 & 0xF]);
                ret.append(HEX_DIGITS[bytes[i] & 0xF]);
            }
            return ret.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String MD5Hash(String source) {
        return EncryptionUtil.getHash(source, "MD5");
    }

    public static String SHAHash(String source) {
        return EncryptionUtil.getHash(source, "SHA");
    }

    public static String SHA1Hash(String source) {
        return EncryptionUtil.getHash(source, "SHA1");
    }

    public static String Encode3Des(String key, String srcStr) {
        return EncryptionUtil.encodeDes(key, srcStr, DES3_FLAG);
    }

    public static String EncodeDes(String key, String srcStr) {
        return EncryptionUtil.encodeDes(key, srcStr, DES_FLAG);
    }

    public static String Decode3Des(String key, String desStr) {
        return EncryptionUtil.decodeDes(key, desStr, DES3_FLAG);
    }

    public static String DecodeDes(String key, String desStr) {
        return EncryptionUtil.decodeDes(key, desStr, DES_FLAG);
    }

    static {
        msMapDES2Mode.put(DES_FLAG, "DES/ECB/PKCS5Padding");
        msMapDES2Mode.put(DES3_FLAG, "DESede/ECB/PKCS5Padding");
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }
}

