/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.log;

import com.global.base.log.LogConsumerWork;
import com.global.base.log.LogInfoData;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executors;

public class LogDisruptorProductMgr {
    private static volatile LogDisruptorProductMgr msInstance = null;
    private String mStrClassName = this.getClass().getSimpleName();
    private volatile boolean mBInited = false;
    private volatile Disruptor<LogInfoData> disruptor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LogDisruptorProductMgr getInstance() {
        if (msInstance != null) return msInstance;
        Class<LogDisruptorProductMgr> clazz = LogDisruptorProductMgr.class;
        synchronized (LogDisruptorProductMgr.class) {
            if (msInstance != null) return msInstance;
            msInstance = new LogDisruptorProductMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return msInstance;
        }
    }

    private LogDisruptorProductMgr() {
    }

    public boolean isInited() {
        return this.mBInited;
    }

    public RingBuffer<LogInfoData> getRingBuffer() {
        if (this.disruptor != null && this.mBInited) {
            return this.disruptor.getRingBuffer();
        }
        return null;
    }

    public void init(int poolSize, int handlerSize) {
        this.disruptor = new Disruptor<LogInfoData>(new EventFactory<LogInfoData>(){

            @Override
            public LogInfoData newInstance() {
                return new LogInfoData("");
            }
        }, 4096, Executors.newFixedThreadPool(poolSize <= 0 ? 1 : poolSize), ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.setDefaultExceptionHandler(new ExceptionHandler<LogInfoData>(){

            @Override
            public void handleEventException(Throwable ex, long sequence, LogInfoData event) {
            }

            @Override
            public void handleOnStartException(Throwable ex) {
            }

            @Override
            public void handleOnShutdownException(Throwable ex) {
            }
        });
        LogConsumerWork[] handlers = new LogConsumerWork[handlerSize];
        for (int i = 0; i < handlerSize; ++i) {
            handlers[i] = new LogConsumerWork();
        }
        this.disruptor.handleEventsWithWorkerPool(handlers);
        this.disruptor.start();
        this.mBInited = true;
    }

    public void destroy() {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        }
        this.mBInited = false;
    }
}

