/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.tools;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShortIDUtil {
    private static final String CHARSET = "123456789ABCDEFGHIJKLMNPQRSTUVWXYZ";
    private static final int RADIX = "123456789ABCDEFGHIJKLMNPQRSTUVWXYZ".length();

    public static String genId(String input, int outLen, String salt) {
        try {
            if (salt == null) {
                salt = "";
            }
            if (outLen < 6) {
                outLen = 6;
            } else if (outLen > 16) {
                outLen = 16;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest((input + salt).getBytes(StandardCharsets.UTF_8));
            BigInteger bigInt = new BigInteger(1, hash);
            StringBuilder baseString = new StringBuilder();
            BigInteger zero = BigInteger.ZERO;
            while (bigInt.compareTo(zero) > 0) {
                BigInteger[] divAndRem = bigInt.divideAndRemainder(BigInteger.valueOf(RADIX));
                bigInt = divAndRem[0];
                baseString.insert(0, CHARSET.charAt(divAndRem[1].intValue()));
            }
            while (baseString.length() < outLen) {
                baseString.insert(0, CHARSET.charAt(0));
            }
            return baseString.substring(0, outLen);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

