/*
 * Decompiled with CFR 0.152.
 */
package com.global.base.delayqueue;

import com.global.base.delayqueue.DelayTaskQueue;
import com.global.base.taskqueue.TaskQueueData;
import java.util.concurrent.atomic.AtomicBoolean;

public class BaseDelayTaskQueueHandler
implements Runnable {
    protected DelayTaskQueue mTaskQueue = new DelayTaskQueue();
    protected AtomicBoolean mBNeedExpand = new AtomicBoolean(false);
    protected int MAX_EXPAND_WARN = 100;
    protected float EXPAND_STEP_THRESHOLD = 0.2f;
    protected int EXPAND_TOTAL_INTERVAL = 60000;
    private long mLastWarnStartTm = 0L;

    public void initParams(int maxExpandWarn, float expandStepThreshold, int msExpandTotalInterval) {
        int n = this.MAX_EXPAND_WARN = maxExpandWarn <= 0 ? 100 : maxExpandWarn;
        this.EXPAND_STEP_THRESHOLD = expandStepThreshold <= 0.0f ? 0.2f : (expandStepThreshold > 1.0f ? 1.0f : expandStepThreshold);
        this.EXPAND_TOTAL_INTERVAL = msExpandTotalInterval <= 0 ? 60000 : msExpandTotalInterval;
    }

    public <T> boolean postTaskData(int type, T data, long expiredMs) {
        return this.mTaskQueue.postTaskData(type, data, expiredMs);
    }

    public boolean postTaskData(TaskQueueData taskData, long expiredMs) {
        return this.mTaskQueue.postTaskData(taskData, expiredMs);
    }

    public void quitTaskQueue(boolean isClearTask) {
        this.mTaskQueue.postQuitTask(isClearTask);
    }

    public TaskQueueData getTaskData() {
        return this.mTaskQueue.getTaskData();
    }

    public TaskQueueData fastGetTaskData() {
        return this.mTaskQueue.fastGetTaskData();
    }

    public int getTaskCount() {
        return this.mTaskQueue.getTaskCount();
    }

    public boolean isNeedExpandTaskQueue() {
        return this.mBNeedExpand.get();
    }

    public void setNeedExpandTaskQueue(boolean bNeed) {
        this.mBNeedExpand.set(bNeed);
    }

    public boolean refreshNeedExpandFlag() {
        int nNewTaskCounts = this.getTaskCount();
        if (nNewTaskCounts >= this.MAX_EXPAND_WARN && nNewTaskCounts - this.MAX_EXPAND_WARN >= (int)((float)this.MAX_EXPAND_WARN * this.EXPAND_STEP_THRESHOLD)) {
            long lCurTm = System.currentTimeMillis();
            if (this.mLastWarnStartTm <= 0L) {
                this.mLastWarnStartTm = lCurTm;
            } else if (lCurTm - this.mLastWarnStartTm >= (long)this.EXPAND_TOTAL_INTERVAL) {
                this.mLastWarnStartTm = 0L;
                this.MAX_EXPAND_WARN += (int)((float)this.MAX_EXPAND_WARN * this.EXPAND_STEP_THRESHOLD);
                this.setNeedExpandTaskQueue(true);
            }
        } else {
            this.mLastWarnStartTm = 0L;
        }
        return this.isNeedExpandTaskQueue();
    }

    @Override
    public void run() {
    }

    public <T> void executeCallBack(boolean bSuccessOrFailed, int type, T data) {
    }

    public void executeCallBack(boolean bSuccessOrFailed, TaskQueueData taskData) {
    }

    public void timePerSecondNow() {
    }
}

