/*
 * Decompiled with CFR 0.152.
 */
package com.bosch.mtprotocol.glm100C;

import com.bosch.mtprotocol.MtConnection;
import com.bosch.mtprotocol.MtFrameFactory;
import com.bosch.mtprotocol.MtMessage;
import com.bosch.mtprotocol.MtMessageFactory;
import com.bosch.mtprotocol.MtProtocol;
import com.bosch.mtprotocol.glm100C.MtFrameConstants;
import com.bosch.mtprotocol.glm100C.MtTimer;
import com.bosch.mtprotocol.glm100C.event.MtProtocolFatalErrorEvent;
import com.bosch.mtprotocol.glm100C.event.MtProtocolReceiveMessageEvent;
import com.bosch.mtprotocol.glm100C.event.MtProtocolRequestTimeoutEvent;
import com.bosch.mtprotocol.glm100C.frame.MtBaseFrame;
import com.bosch.mtprotocol.glm100C.frame.MtFrameByteReader;
import com.bosch.mtprotocol.glm100C.frame.MtRequestFrame;
import com.bosch.mtprotocol.glm100C.message.FrameFactoryImpl;
import com.bosch.mtprotocol.glm100C.message.MessageFactoryImpl;
import com.bosch.mtprotocol.glm100C.state.MtProtocolStateMachine;
import com.bosch.mtprotocol.glm100C.state.MtProtocolStates;
import com.bosch.mtprotocol.util.statemachine.StateMachine;
import com.bosch.mtprotocol.util.statemachine.exc.StateMachineDescriptorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public class MtProtocolImpl
implements MtProtocol,
MtFrameConstants,
MtTimer.MtTimerListener,
MtProtocolStates {
    private static final Logger LOG = Logger.getLogger(MtProtocol.class.getName());
    private static final int RX_FIFO_SIZE = 2500;
    private static final int TX_FIFO_SIZE = 255;
    private StateMachine stateMachine;
    private Set<MtProtocol.MTProtocolEventObserver> observers;
    private MtFrameFactory frameFactory;
    private MtMessageFactory messageFactory;
    private LinkedBlockingQueue<MtMessage> outgoingQueue;
    private MtRequestFrame currentRequest;
    private SendThread sendThread;
    private ReceiveThread receiveThread;
    private MtConnection connection;
    private MtFrameByteReader frameReader;
    private ArrayList<MtMessage> messages;
    private int timeout;

    public MtProtocolImpl() {
        ArrayList arrayList;
        LinkedBlockingQueue linkedBlockingQueue;
        MessageFactoryImpl messageFactoryImpl;
        FrameFactoryImpl frameFactoryImpl;
        HashSet hashSet;
        Object object = hashSet;
        hashSet = new HashSet();
        v1.observers = object;
        object = frameFactoryImpl;
        frameFactoryImpl = new FrameFactoryImpl();
        v1.frameFactory = object;
        object = messageFactoryImpl;
        messageFactoryImpl = new MessageFactoryImpl();
        v1.messageFactory = object;
        object = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue();
        v1.outgoingQueue = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.messages = object;
    }

    private synchronized void checkTransactionCompleted() {
        Object object = this.frameReader;
        if (object != null && ((MtFrameByteReader)object).isFrameRcvComplete()) {
            block10: {
                LOG.finest("MtProtocol: Buffer receive complete or timeout");
                object = this.receiveThread;
                if (object != null) {
                    ((ReceiveThread)object).stopTimeoutTimer();
                }
                MtProtocolImpl mtProtocolImpl = this;
                mtProtocolImpl.stateMachine.processEvent("RECEIVE_FINISH");
                if (!mtProtocolImpl.outgoingQueue.isEmpty()) break block10;
                if (this.stateMachine.getCurrentState() != "MASTER_READY") break block10;
                try {
                    this.stateMachine.processEvent("SWITCH_TO_SLAVE");
                }
                catch (StateMachineDescriptorException stateMachineDescriptorException) {
                    stateMachineDescriptorException.printStackTrace();
                }
            }
            for (MtMessage mtMessage : this.messages) {
                if (mtMessage == null) {
                    LOG.finest("Erorr occured when turning received frame to message");
                    this.notifyObservers(new MtProtocolFatalErrorEvent());
                } else {
                    LOG.finest("Received message: " + mtMessage);
                    this.notifyObservers(new MtProtocolReceiveMessageEvent(mtMessage));
                }
                this.notify();
            }
            this.messages.clear();
            this.frameReader = null;
        } else {
            LOG.warning("MtProtocol: Frame receive not complete");
        }
    }

    private void checkMessageComplete() {
        LOG.finest("MtProtocol: Frame receive complete");
        if (this.frameReader.getComStatus() == 0) {
            Object object;
            MtProtocolImpl mtProtocolImpl = this;
            MtBaseFrame mtBaseFrame = (MtBaseFrame)mtProtocolImpl.frameReader.getFrame();
            if (mtProtocolImpl.stateMachine.getCurrentState() == "MASTER_RECEIVING" && mtBaseFrame.getCommand() == 0) {
                object = this.currentRequest;
                if (object != null) {
                    mtBaseFrame.setCommand(((MtBaseFrame)object).getCommand());
                } else {
                    LOG.warning("Unknown response received! Current request is NULL");
                }
            }
            object = null;
            try {
                object = this.messageFactory.createMessage(mtBaseFrame);
            }
            catch (Exception exception) {}
            this.messages.add((MtMessage)object);
        } else {
            MtProtocolImpl mtProtocolImpl = this;
            LOG.warning("MtProtocol: Communication error");
            mtProtocolImpl.notifyObservers(new MtProtocolFatalErrorEvent());
            mtProtocolImpl.notify();
        }
    }

    private void notifyObservers(MtProtocol.MTProtocolEvent mTProtocolEvent) {
        Iterator<MtProtocol.MTProtocolEventObserver> iterator = ((MtProtocolImpl)((Object)iterator)).observers.iterator();
        while (iterator.hasNext()) {
            ((MtProtocol.MTProtocolEventObserver)iterator.next()).onEvent(mTProtocolEvent);
        }
    }

    static /* synthetic */ SendThread access$300(MtProtocolImpl mtProtocolImpl) {
        return mtProtocolImpl.sendThread;
    }

    static /* synthetic */ LinkedBlockingQueue access$400(MtProtocolImpl mtProtocolImpl) {
        return mtProtocolImpl.outgoingQueue;
    }

    static /* synthetic */ MtFrameFactory access$600(MtProtocolImpl mtProtocolImpl) {
        return mtProtocolImpl.frameFactory;
    }

    static /* synthetic */ MtRequestFrame access$702(MtProtocolImpl mtProtocolImpl, MtRequestFrame mtRequestFrame) {
        mtProtocolImpl.currentRequest = mtRequestFrame;
        return mtRequestFrame;
    }

    static /* synthetic */ MtFrameByteReader access$1002(MtProtocolImpl mtProtocolImpl, MtFrameByteReader mtFrameByteReader) {
        mtProtocolImpl.frameReader = mtFrameByteReader;
        return mtFrameByteReader;
    }

    @Override
    public void reset() {
        MtProtocolImpl mtProtocolImpl = this;
        mtProtocolImpl.initialize(mtProtocolImpl.connection);
    }

    @Override
    public void initialize(MtConnection object) {
        SendThread sendThread;
        MtProtocolImpl mtProtocolImpl = this;
        this.stateMachine = new MtProtocolStateMachine();
        mtProtocolImpl.connection = object;
        mtProtocolImpl.frameReader = null;
        mtProtocolImpl.currentRequest = null;
        mtProtocolImpl.messages.clear();
        mtProtocolImpl.outgoingQueue.clear();
        object = mtProtocolImpl.sendThread;
        if (object != null) {
            ((Thread)object).interrupt();
        }
        object = sendThread;
        ((SendThread)object)();
        this.sendThread = object;
        sendThread.start();
        object = this.receiveThread;
        if (object != null) {
            ((Thread)object).interrupt();
        }
        MtProtocolImpl mtProtocolImpl2 = this;
        this.receiveThread = new ReceiveThread();
        this.receiveThread.setPriority(10);
        mtProtocolImpl2.receiveThread.start();
        try {
            mtProtocolImpl2.stateMachine.processEvent("INITIALIZE_SLAVE");
            return;
        }
        catch (StateMachineDescriptorException stateMachineDescriptorException) {
            throw new RuntimeException("Can't initialize MTProtocol", stateMachineDescriptorException);
        }
    }

    @Override
    public synchronized void sendMessage(MtMessage mtMessage) {
        if (this.stateMachine.getCurrentState() == "SLAVE_LISTENING") {
            try {
                this.stateMachine.processEvent("SWITCH_TO_MASTER");
            }
            catch (StateMachineDescriptorException stateMachineDescriptorException) {
                stateMachineDescriptorException.printStackTrace();
                return;
            }
        }
        LOG.finest("MtProtocol: Adding outgoing message to queue.");
        if (this.outgoingQueue.offer(mtMessage)) {
            return;
        }
        throw new RuntimeException("MtProtocol: Error: outgoing queue is full, message dropped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void onTimerTick() {
        v0 = this;
        v0.stateMachine.processEvent("SET_TIMEOUT");
        if (v0.frameReader == null) ** GOTO lbl16
        var1_1 = this.frameReader;
        v1 = this;
        // MONITORENTER : var1_1
        try {
            v1.frameReader = null;
            // MONITOREXIT : var1_1
            ** GOTO lbl16
        }
        catch (Throwable v2) {
            // MONITOREXIT : var1_1
            throw v2;
lbl16:
            // 2 sources

            if (this.stateMachine.getCurrentState() != "MASTER_READY") ** GOTO lbl19
            try {
                this.stateMachine.processEvent("SWITCH_TO_SLAVE");
lbl19:
                // 2 sources

                this.notifyObservers(new MtProtocolRequestTimeoutEvent());
                return;
            }
            catch (StateMachineDescriptorException v3) {
                v3.printStackTrace();
            }
        }
    }

    public synchronized boolean setSlave() {
        try {
            this.stateMachine.processEvent("SWITCH_TO_SLAVE");
            return true;
        }
        catch (StateMachineDescriptorException stateMachineDescriptorException) {
            stateMachineDescriptorException.printStackTrace();
            return false;
        }
    }

    public synchronized boolean setMaster() {
        try {
            this.stateMachine.processEvent("SWITCH_TO_MASTER");
            return true;
        }
        catch (StateMachineDescriptorException stateMachineDescriptorException) {
            stateMachineDescriptorException.printStackTrace();
            return false;
        }
    }

    @Override
    public void destroy() {
        MtProtocolImpl mtProtocolImpl = this;
        mtProtocolImpl.observers.clear();
        Thread thread = mtProtocolImpl.sendThread;
        if (thread != null) {
            ((SendThread)thread).stopTimeoutTimer();
            this.sendThread.interrupt();
        }
        if ((thread = this.receiveThread) != null) {
            ((ReceiveThread)thread).stopTimeoutTimer();
            this.receiveThread.interrupt();
        }
    }

    @Override
    public void setTimeout(int n2) {
        this.timeout = n2;
    }

    @Override
    public void addObserver(MtProtocol.MTProtocolEventObserver mTProtocolEventObserver) {
        this.observers.add(mTProtocolEventObserver);
    }

    @Override
    public void removeObserver(MtProtocol.MTProtocolEventObserver mTProtocolEventObserver) {
        this.observers.remove(mTProtocolEventObserver);
    }

    private class ReceiveThread
    extends Thread {
        private MtTimer timeoutTimer;

        private ReceiveThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                block13: {
                    int n2;
                    byte[] byArray;
                    block15: {
                        block14: {
                            if (MtProtocolImpl.this.connection == null || !MtProtocolImpl.this.connection.isOpen()) continue;
                            byArray = new byte[2500];
                            try {
                                n2 = MtProtocolImpl.this.connection.read(byArray);
                                if (n2 == 0) continue;
                                this.startTimeoutTimer();
                                if (n2 == 0) break block13;
                                if (MtProtocolImpl.this.stateMachine.getCurrentState() != "SLAVE_LISTENING") break block14;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                MtProtocolImpl.this.connection.closeConnection();
                                return;
                            }
                            try {
                                MtProtocolImpl.this.stateMachine.processEvent("RECEIVE_START");
                            }
                            catch (StateMachineDescriptorException stateMachineDescriptorException) {
                                stateMachineDescriptorException.printStackTrace();
                            }
                        }
                        if (MtProtocolImpl.this.stateMachine.getCurrentState() == "SLAVE_RECEIVING" || MtProtocolImpl.this.stateMachine.getCurrentState() == "MASTER_RECEIVING") break block15;
                        LOG.warning("MtProtocolImpl: Ignoring received data; Current state: " + MtProtocolImpl.this.stateMachine.getCurrentState());
                        break block13;
                    }
                    if (MtProtocolImpl.this.frameReader == null) {
                        MtProtocolImpl.access$1002(MtProtocolImpl.this, new MtFrameByteReader(new byte[2500], 2500));
                    }
                    MtFrameByteReader mtFrameByteReader = MtProtocolImpl.this.frameReader;
                    // MONITORENTER : mtFrameByteReader
                    for (int i3 = 0; i3 < n2; ++i3) {
                        ReceiveThread receiveThread = this;
                        byte by = byArray[i3];
                        receiveThread.MtProtocolImpl.this.frameReader.append(by);
                        if (!receiveThread.MtProtocolImpl.this.frameReader.isFrameRcvComplete()) continue;
                        MtProtocolImpl.this.checkMessageComplete();
                        if (i3 >= n2 - 1) continue;
                        ReceiveThread receiveThread2 = this;
                        ReceiveThread receiveThread3 = receiveThread2;
                        MtProtocolImpl.access$1002(receiveThread2.MtProtocolImpl.this, null);
                        MtProtocolImpl.access$1002(receiveThread3.MtProtocolImpl.this, new MtFrameByteReader(new byte[2500], 2500));
                    }
                    // MONITOREXIT : mtFrameByteReader
                }
                MtProtocolImpl.this.checkTransactionCompleted();
            }
        }

        public synchronized void startTimeoutTimer() {
            MtTimer mtTimer;
            MtTimer mtTimer2;
            ReceiveThread receiveThread = this;
            receiveThread.stopTimeoutTimer();
            MtTimer mtTimer3 = mtTimer2 = mtTimer;
            mtTimer3(MtProtocolImpl.this.timeout);
            this.timeoutTimer = mtTimer3;
            mtTimer.setListener(MtProtocolImpl.this);
            receiveThread.timeoutTimer.start();
        }

        public synchronized void stopTimeoutTimer() {
            MtTimer mtTimer = this.timeoutTimer;
            if (mtTimer != null) {
                mtTimer.setListener(null);
                this.timeoutTimer.stop();
                this.timeoutTimer = null;
            }
        }
    }

    private class SendThread
    extends Thread {
        private MtTimer timeoutTimer;

        private SendThread() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public synchronized void startTimeoutTimer() {
            MtTimer mtTimer;
            MtTimer mtTimer2;
            SendThread sendThread = this;
            sendThread.stopTimeoutTimer();
            MtTimer mtTimer3 = mtTimer2 = mtTimer;
            mtTimer3(MtProtocolImpl.this.timeout);
            this.timeoutTimer = mtTimer3;
            mtTimer.setListener(MtProtocolImpl.this);
            sendThread.timeoutTimer.start();
        }

        public synchronized void stopTimeoutTimer() {
            MtTimer mtTimer = this.timeoutTimer;
            if (mtTimer != null) {
                mtTimer.setListener(null);
                this.timeoutTimer.stop();
                this.timeoutTimer = null;
            }
        }
    }
}

