/*
 * Decompiled with CFR 0.152.
 */
package com.bosch.mtprotocol.glm100C.message.edc;

import com.bosch.mtprotocol.MtMessage;
import com.bosch.mtprotocol.type.UnionUint32;

public class EDCInputMessage
implements MtMessage {
    public static final int REF_EDGE_ANGLE_BACK = 0;
    public static final int REF_EDGE_ANGLE_SIDE = 1;
    public static final int REF_EDGE_ANGLE_RAIL = 2;
    public static final int REF_EDGE_DISTANCE_FRONT = 0;
    public static final int REF_EDGE_DISTANCE_TRIPOD = 1;
    public static final int REF_EDGE_DISTANCE_REAR = 2;
    public static final int REF_EDGE_DISTANCE_PIN = 3;
    public static final int MODE_NO_ACTION = 0;
    public static final int MODE_SINGLE_DISTANCE = 1;
    public static final int MODE_CONTINUOUS_DISTANCE = 2;
    public static final int MODE_AREA_PART_1 = 3;
    public static final int MODE_AREA_FINAL = 4;
    public static final int MODE_VOLUME_PART_1 = 5;
    public static final int MODE_VOLUME_PART_2 = 6;
    public static final int MODE_VOLUME_FINAL = 7;
    public static final int MODE_SINGLE_ANGLE = 8;
    public static final int MODE_CONTINUOUS_ANGLE = 9;
    public static final int MODE_INDIRECT_HEIGHT = 10;
    public static final int MODE_INDIRECT_LENGTH = 11;
    public static final int MODE_DOUBLE_INDIRECT_HEIGHT_PART_1 = 12;
    public static final int MODE_DOUBLE_INDIRECT_HEIGHT_FINAL = 13;
    public static final int MODE_WALL_AREA_PART_1 = 14;
    public static final int MODE_WALL_AREA_FINAL = 15;
    public static final int MODE_CALCULATED_DISTANCE_PLUS = 16;
    public static final int MODE_CALCULATED_DISTANCE_MINUS = 17;
    public static final int MODE_CALCULATED_AREA_PLUS = 18;
    public static final int MODE_CALCULATED_AREA_MINUS = 19;
    public static final int MODE_CALCULATED_VOLUME_PLUS = 20;
    public static final int MODE_CALCULATED_VOLUME_MINUS = 21;
    public static final int MODE_SINGLE_LEVEL = 22;
    public static final int MODE_CONTINUOUS_LEVEL = 23;
    public static final int MODE_TRAPEZOID_PART_1 = 24;
    public static final int MODE_TRAPEZOID_PART_2 = 25;
    public static final int MODE_TRAPEZOID_FINAL = 26;
    public static final int MODE_GET_TIMESTAMP_OF_LIST_ITEM = 57;
    public static final int MODE_GET_LIST_ITEM_BY_INDEX = 58;
    public static final int MODE_TEMPERATURE_AND_SOC = 59;
    public static final int MODE_SET_DEV_MODE = 60;
    public static final int MODE_SET_ANGLE_REFERENCE = 61;
    public static final int MODE_SET_DISTANCE_REFERENCE = 62;
    public static final int MODE_ERROR_RESPONSE = 63;
    public static final int WARNING_TEMP_STATUS_OFF = 0;
    public static final int WARNING_TEMP_STATUS_ON = 1;
    public static final int WARNING_BATT_STATUS_OFF = 0;
    public static final int WARNING_BATT_STATUS_ON = 1;
    public static final int LASER_OFF = 0;
    public static final int LASER_ON = 1;
    public static final int CONFIG_UNITS_METRIC = 0;
    public static final int CONFIG_UNITS_IMPERIAL = 1;
    private int refEdge;
    private int devMode;
    private int status;
    private int laserOn;
    private int tempStatus;
    private int batLowStatus;
    private int configUnits;
    private int measID;
    private float result;
    private float comp1;
    private float comp2;

    public static int turnSyncModeToEDCMode(int n2) {
        int n3;
        switch (n2) {
            default: {
                n3 = 0;
                break;
            }
            case 14: {
                n3 = 26;
                break;
            }
            case 10: {
                n3 = 15;
                break;
            }
            case 9: {
                n3 = 13;
                break;
            }
            case 8: {
                n3 = 11;
                break;
            }
            case 7: {
                n3 = 10;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
            case 4: {
                n3 = 8;
                break;
            }
            case 3: {
                n3 = 7;
                break;
            }
            case 2: {
                n3 = 4;
                break;
            }
            case 1: {
                n3 = 1;
            }
        }
        return n3;
    }

    public static int turnEDCModeToSyncMode(int n2) {
        int n3;
        switch (n2) {
            default: {
                n3 = 0;
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                n3 = 14;
                break;
            }
            case 14: 
            case 15: {
                n3 = 10;
                break;
            }
            case 12: 
            case 13: {
                n3 = 9;
                break;
            }
            case 11: {
                n3 = 8;
                break;
            }
            case 10: {
                n3 = 7;
                break;
            }
            case 8: 
            case 9: {
                n3 = 4;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 20: 
            case 21: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 18: 
            case 19: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 6;
                break;
            }
            case 1: 
            case 16: 
            case 17: {
                n3 = 1;
            }
        }
        return n3;
    }

    public static int mtCastFromFloatToInt(float f3) {
        UnionUint32 unionUint32 = new UnionUint32();
        unionUint32.setValue(Float.floatToIntBits(f3));
        return unionUint32.getValue();
    }

    public int getRefEdge() {
        return this.refEdge;
    }

    public void setRefEdge(int n2) {
        this.refEdge = n2;
    }

    public int getDevMode() {
        return this.devMode;
    }

    public void setDevMode(int n2) {
        this.devMode = n2;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n2) {
        this.status = n2;
    }

    public int getLaserOn() {
        return this.laserOn;
    }

    public void setLaserOn(int n2) {
        this.laserOn = n2;
    }

    public int getTempStatus() {
        return this.tempStatus;
    }

    public void setTempStatus(int n2) {
        this.tempStatus = n2;
    }

    public int getBatLowStatus() {
        return this.batLowStatus;
    }

    public void setBatLowStatus(int n2) {
        this.batLowStatus = n2;
    }

    public int getConfigUnits() {
        return this.configUnits;
    }

    public void setConfigUnits(int n2) {
        this.configUnits = n2;
    }

    public int getMeasID() {
        return this.measID;
    }

    public void setMeasID(int n2) {
        this.measID = n2;
    }

    public float getResult() {
        return this.result;
    }

    public void setResult(float f3) {
        this.result = f3;
    }

    public float getComp1() {
        return this.comp1;
    }

    public void setComp1(float f3) {
        this.comp1 = f3;
    }

    public float getComp2() {
        return this.comp2;
    }

    public void setComp2(float f3) {
        this.comp2 = f3;
    }

    public String toString() {
        return "EDCInputMessage [devMode=" + this.devMode + ", refEdge=" + this.refEdge + ", errStatus=" + this.status + ", laserOn=" + this.laserOn + ", configUnits=" + this.configUnits + ", temperature warning=" + this.tempStatus + ", battery warning=" + this.batLowStatus + ", measID=" + this.measID + ", result=" + this.result + ", comp1=" + this.comp1 + ", comp2=" + this.comp2 + "]";
    }
}

