/*
 * Decompiled with CFR 0.152.
 */
package com.huace.gnssserver.sdk.databack.record;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.huace.gnssserver.debug.IDebugDataRecord;
import com.huace.gnssserver.sdk.databack.DataBackSetting;
import com.huace.gnssserver.sdk.databack.record.DiffDataRecorder;
import com.huace.gnssserver.sdk.databack.record.ExpiredFileCleaner;
import com.huace.gnssserver.sdk.databack.record.HrxcDataRecorder;

public class ObserveDataRecordManager {
    private static final ObserveDataRecordManager ourInstance = new ObserveDataRecordManager();
    private boolean mIsRecord = false;
    private IDebugDataRecord mHrcxDataRecorder = null;
    private IDebugDataRecord mDiffDataRecorder = null;

    public static ObserveDataRecordManager getInstance() {
        return ourInstance;
    }

    private ObserveDataRecordManager() {
    }

    private void notifyRecordStatusChanged() {
        ObserveDataRecordManager observeDataRecordManager = this;
        observeDataRecordManager.getHrcxDataRecorder().notifyParameterChanged();
        observeDataRecordManager.getDiffDataRecorder().notifyParameterChanged();
    }

    @NonNull
    private IDebugDataRecord getHrcxDataRecorder() {
        if (this.mHrcxDataRecorder == null) {
            HrxcDataRecorder hrxcDataRecorder;
            HrxcDataRecorder hrxcDataRecorder2 = hrxcDataRecorder;
            hrxcDataRecorder = new HrxcDataRecorder();
            this.mHrcxDataRecorder = hrxcDataRecorder2;
        }
        return this.mHrcxDataRecorder;
    }

    @NonNull
    private IDebugDataRecord getDiffDataRecorder() {
        if (this.mDiffDataRecorder == null) {
            DiffDataRecorder diffDataRecorder;
            DiffDataRecorder diffDataRecorder2 = diffDataRecorder;
            diffDataRecorder = new DiffDataRecorder();
            this.mDiffDataRecorder = diffDataRecorder2;
        }
        return this.mDiffDataRecorder;
    }

    public void start() {
        if (this.mIsRecord) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)DataBackSetting.getInstance().getRecordFolder())) {
            return;
        }
        this.mIsRecord = true;
        this.notifyRecordStatusChanged();
        ExpiredFileCleaner.getInstance().start();
    }

    public void stop() {
        if (!this.mIsRecord) {
            return;
        }
        this.mIsRecord = false;
        this.notifyRecordStatusChanged();
    }

    public boolean isRecord() {
        return this.mIsRecord;
    }
}

