/*
 * Decompiled with CFR 0.152.
 */
package com.huace.gnssserver.sdk.databack.upload;

import com.huace.gnssserver.sdk.databack.upload.DataQualityChecker;
import com.huace.gnssserver.sdk.databack.upload.SwasServerLoginManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ObserveDataUploadManager {
    private static final ObserveDataUploadManager ourInstance = new ObserveDataUploadManager();
    private ScheduledExecutorService mReconnectPool;
    private boolean mIsStart = false;
    private final int RECONNECT_INTERVAL;
    private final DataQualityChecker mQualityChecker;

    public static ObserveDataUploadManager getInstance() {
        return ourInstance;
    }

    private ObserveDataUploadManager() {
        DataQualityChecker dataQualityChecker;
        ((ObserveDataUploadManager)((Object)dataQualityChecker2)).RECONNECT_INTERVAL = 600000;
        DataQualityChecker dataQualityChecker2 = dataQualityChecker;
        dataQualityChecker = new DataQualityChecker();
        v1.mQualityChecker = dataQualityChecker2;
    }

    private synchronized void startReconnectTask() {
        Runnable runnable;
        if (object.mReconnectPool != null) {
            return;
        }
        object.mReconnectPool = Executors.newScheduledThreadPool(1);
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ObserveDataUploadManager.this.doConnect();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        Object object = TimeUnit.MILLISECONDS;
        object.mReconnectPool.scheduleAtFixedRate(runnable2, 3000L, 600000L, (TimeUnit)((Object)object));
    }

    private synchronized void closeReconnectTask() {
        ScheduledExecutorService scheduledExecutorService = this.mReconnectPool;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.shutdownNow();
            this.mReconnectPool = null;
        }
    }

    private void doConnect() {
        if (!this.mQualityChecker.isPassed()) {
            return;
        }
        if (!SwasServerLoginManager.getInstance().isConnectingOrConnected()) {
            SwasServerLoginManager.getInstance().connect();
        }
    }

    public void start() {
        if (this.mIsStart) {
            return;
        }
        ObserveDataUploadManager observeDataUploadManager = this;
        observeDataUploadManager.mIsStart = true;
        observeDataUploadManager.startReconnectTask();
        observeDataUploadManager.mQualityChecker.start();
    }

    public void stop() {
        if (!this.mIsStart) {
            return;
        }
        ObserveDataUploadManager observeDataUploadManager = this;
        observeDataUploadManager.mIsStart = false;
        observeDataUploadManager.closeReconnectTask();
        SwasServerLoginManager.getInstance().disConnect();
        observeDataUploadManager.mQualityChecker.stop();
    }
}

