/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ObjectPool<T> {
    private static final int FIX = 20;
    private List<T> mPoolList;
    private int mSize;
    private Class<T> mClass;

    public ObjectPool() {
        this(20);
    }

    public ObjectPool(int n2) {
        this.mSize = n2 <= 0 ? 20 : n2;
        this.mPoolList = Collections.synchronizedList(new LinkedList());
        for (Class clazz = ObjectPool.class; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Type[] typeArray = clazz.getGenericSuperclass();
            if (!(typeArray instanceof ParameterizedType) || !((typeArray = ((ParameterizedType)typeArray).getActualTypeArguments())[0] instanceof Class)) continue;
            this.mClass = (Class)typeArray[0];
            return;
        }
    }

    private T getIntance(Class<T> clazz) {
        return clazz.newInstance();
    }

    public T get(Class<T> clazz) {
        ObjectPool<T> objectPool;
        if (objectPool.mPoolList.size() == 0) {
            try {
                objectPool = objectPool.getIntance(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            objectPool = objectPool.mPoolList.remove(0);
        }
        return (T)objectPool;
    }

    public void release(T t2) {
        if (t2 == null) {
            return;
        }
        if (this.mPoolList.size() >= this.mSize) {
            this.mPoolList.remove(0);
        }
        this.mPoolList.add(t2);
    }

    List<T> getPoolList() {
        return this.mPoolList;
    }
}

