/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.pop.android.common.util.network.NetworkChangedCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NetworkManager {
    private static NetworkManager sManager;
    private static Context mContext;
    List<NetworkChangedCallback> mCallBacks;
    volatile boolean mRsnb;
    Handler mHandler;
    boolean mNetworkStatus;
    final int INIT;
    final int RECIEVERSYSTEMBC;
    final int UNRECIEVERSYSTEMBC;
    int mNetworkFlag = 0;
    BroadcastReceiver myNetReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (context != null && intent != null) {
                block9: {
                    boolean bl;
                    block10: {
                        try {
                            this_.NetworkManager.this.mNetworkFlag = 1;
                            if (!intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) break block9;
                        }
                        catch (Exception exception) {
                            return;
                        }
                        context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
                        bl = false;
                        if (context == null) break block10;
                        if (!context.isAvailable()) break block10;
                        bl = true;
                    }
                    this_.NetworkManager.this.mNetworkStatus = bl;
                    if (this_.NetworkManager.this.mCallBacks.size() <= 0) break block9;
                    if (this_.NetworkManager.this.mHandler == null) break block9;
                    2 v12 = this_;
                    2 this_ = Message.obtain();
                    v2.obj = bl;
                    v12.NetworkManager.this.mHandler.sendMessage((Message)this_);
                }
                return;
            }
        }
    };

    public static void init(Context context) {
        mContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkManager getIntance() {
        if (mContext == null) throw new NullPointerException("please call init function");
        if (sManager != null) return sManager;
        Class<NetworkManager> clazz = NetworkManager.class;
        synchronized (NetworkManager.class) {
            if (sManager != null) return sManager;
            sManager = new NetworkManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sManager;
        }
    }

    NetworkManager() {
        this.INIT = 0;
        this.RECIEVERSYSTEMBC = 1;
        this.UNRECIEVERSYSTEMBC = 2;
        this.mCallBacks = Collections.synchronizedList(new ArrayList());
    }

    private void initHandler() {
        if (this.mHandler == null) {
            Handler handler;
            HandlerThread handlerThread;
            HandlerThread handlerThread2 = handlerThread;
            new HandlerThread("networkListener").start();
            Handler handler2 = handler;
            handler = new Handler(handlerThread2.getLooper()){

                public void handleMessage(Message message) {
                    int n2;
                    boolean bl;
                    try {
                        bl = (Boolean)message.obj;
                        n2 = 0;
                    }
                    catch (Exception exception) {
                        return;
                    }
                    while (true) {
                        if (n2 >= NetworkManager.this.mCallBacks.size()) break;
                        NetworkManager.this.mCallBacks.get(n2).onNetworkChanged(bl);
                        ++n2;
                        continue;
                        break;
                    }
                    return;
                }
            };
            this.mHandler = handler2;
        }
    }

    private void closeHandler() {
        Handler handler = this.mHandler;
        if (handler != null) {
            handler.getLooper().quit();
            this.mHandler = null;
        }
    }

    private void registerSnb() {
        IntentFilter intentFilter;
        this.mRsnb = true;
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.net.conn.CONNECTIVITY_CHANGE");
        mContext.registerReceiver(this.myNetReceiver, intentFilter2);
    }

    private void unregisterSnb() {
        this.mRsnb = false;
        mContext.unregisterReceiver(this.myNetReceiver);
    }

    private boolean isAllNetworkAvailable() {
        NetworkManager networkManager = (ConnectivityManager)mContext.getSystemService("connectivity");
        return networkManager != null && (networkManager = networkManager.getActiveNetworkInfo()) != null && networkManager.isConnected() && networkManager.getState() == NetworkInfo.State.CONNECTED;
    }

    public void registerCallback(NetworkChangedCallback networkChangedCallback) {
        if (networkChangedCallback == null) {
            return;
        }
        if (!this.mRsnb) {
            this.registerSnb();
        }
        NetworkManager networkManager = this;
        networkManager.initHandler();
        networkManager.mCallBacks.add(networkChangedCallback);
    }

    public void unregisterCallback(NetworkChangedCallback networkChangedCallback) {
        if (networkChangedCallback == null) {
            return;
        }
        NetworkManager networkManager = this;
        networkManager.mCallBacks.remove(networkChangedCallback);
        if (networkManager.mCallBacks.size() == 0) {
            this.close();
        }
    }

    public void close() {
        NetworkManager networkManager = this;
        networkManager.mNetworkFlag = 2;
        networkManager.unregisterSnb();
        networkManager.closeHandler();
        networkManager.mNetworkStatus = false;
    }

    public boolean isNetworkAvailable() {
        if (this.mNetworkFlag != 1) {
            return this.isAllNetworkAvailable();
        }
        return this.mNetworkStatus;
    }
}

