/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.parser;

import com.pop.android.common.util.nmea.parser.ParseException;
import com.pop.android.common.util.nmea.parser.PositionParser;
import com.pop.android.common.util.nmea.parser.SentenceParser;
import com.pop.android.common.util.nmea.sentence.SentenceId;
import com.pop.android.common.util.nmea.sentence.TalkerId;
import com.pop.android.common.util.nmea.util.Position;
import com.pop.android.common.util.nmea.util.Time;
import com.pop.android.common.util.nmea.util.Units;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NAVParser
extends PositionParser {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
    private static final int UTC_TIME = 0;
    private static final int LATITUDE = 1;
    private static final int LAT_HEMISPHERE = 2;
    private static final int LONGITUDE = 3;
    private static final int LON_HEMISPHERE = 4;
    private static final int ALTITUDE = 5;
    private static final int ALTITUDE_UNITS = 6;
    private static final int SPEED = 7;
    private static final int COURSE = 8;
    private static final int UTC_DATE = 9;
    private static final int SATELLITES_IN_USE = 10;
    private static final int BEIDOU_IN_USE = 11;
    private static final int CN0_GREAT_THAN_40 = 12;
    private static final int HORIZONTAL_DILUTION = 13;
    private static final int DGPS_AGE = 14;
    private static final int QUALITY_FLAG = 15;
    private static final int ERROR_FLAG = 16;
    private static final int GNSS_CPU = 17;
    private static final int INS_CPU = 18;
    private static final int LIVE_COUNT = 19;
    char ALT_UNIT_METERS = (char)77;
    char ALT_UNIT_FEET = (char)102;

    public NAVParser(String string) {
        super(string, SentenceId.V);
    }

    public NAVParser(TalkerId talkerId) {
        super(talkerId, SentenceId.V, 20);
    }

    public Time getTime() {
        String string = ((SentenceParser)((Object)string)).getStringValue(0);
        return new Time(string);
    }

    public Position getPosition() {
        NAVParser nAVParser = this;
        Position position = nAVParser.parsePosition(1, 2, 3, 4);
        if (nAVParser.hasValue(5) && this.hasValue(6)) {
            NAVParser nAVParser2 = this;
            double d3 = nAVParser2.getAltitude();
            if (nAVParser2.getAltitudeUnits().equals((Object)Units.FEET)) {
                d3 /= 0.3048;
            }
            position.setAltitude(d3);
        }
        return position;
    }

    public double getAltitude() {
        return this.getDoubleValue(5);
    }

    public Units getAltitudeUnits() {
        char c3 = objectArray2.getCharValue(6);
        if (c3 != objectArray2.ALT_UNIT_METERS && c3 != objectArray2.ALT_UNIT_FEET) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Character.valueOf(c3);
            throw new ParseException(String.format("Invalid altitude unit indicator: %s", objectArray2));
        }
        return Units.valueOf(c3);
    }

    public double getSpeed() {
        return this.getDoubleValue(7);
    }

    public double getCourse() {
        return this.getDoubleValue(8);
    }

    public Date getUtcDate() {
        String string = ((SentenceParser)((Object)string)).getStringValue(9);
        return new com.pop.android.common.util.nmea.util.Date(string).toDate();
    }

    public int getSatelliteCount() {
        return this.getIntValue(10);
    }

    public int getBeidouCount() {
        return this.getIntValue(11);
    }

    public int getCn0GreatThan40Count() {
        return this.getIntValue(12);
    }

    public String getHorizontalDOP() {
        return this.getStringValue(13);
    }

    public int getDgpsAge() {
        int n2 = 0;
        try {
            n2 = this.getIntValue(14);
        }
        catch (Exception exception) {}
        return n2;
    }

    public char getQualityFlag() {
        return this.getCharValue(15);
    }

    public String getErrorFlag() {
        return this.getStringValue(16);
    }

    public int getGnssCpu() {
        return this.getIntValue(17);
    }

    public int getInsCpu() {
        return this.getIntValue(18);
    }

    public int getLiveCount() {
        return this.getIntValue(19);
    }
}

