/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.parser;

import com.pop.android.common.util.nmea.parser.ParseException;
import com.pop.android.common.util.nmea.parser.SentenceParser;
import com.pop.android.common.util.nmea.sentence.SentenceId;
import com.pop.android.common.util.nmea.sentence.TalkerId;
import com.pop.android.common.util.nmea.util.CompassPoint;
import com.pop.android.common.util.nmea.util.Position;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

abstract class PositionParser
extends SentenceParser {
    protected PositionParser(String string, SentenceId sentenceId) {
        super(string, sentenceId);
    }

    protected PositionParser(TalkerId talkerId, SentenceId sentenceId, int n2) {
        super(talkerId, sentenceId, n2);
    }

    protected CompassPoint parseHemisphereLat(int n2) {
        char c3 = this.getCharValue(n2);
        CompassPoint compassPoint = CompassPoint.valueOf(c3);
        if (compassPoint != CompassPoint.NORTH && compassPoint != CompassPoint.SOUTH) {
            throw new ParseException("Invalid latitude hemisphere '" + c3 + "'");
        }
        return compassPoint;
    }

    protected CompassPoint parseHemisphereLon(int n2) {
        char c3 = this.getCharValue(n2);
        CompassPoint compassPoint = CompassPoint.valueOf(c3);
        if (compassPoint != CompassPoint.EAST && compassPoint != CompassPoint.WEST) {
            throw new ParseException("Invalid longitude hemisphere " + c3 + "'");
        }
        return compassPoint;
    }

    protected double parseLatitude(int n2) {
        String string = this.getStringValue(n2);
        int n3 = Integer.parseInt(string.substring(0, 2));
        double d3 = Double.parseDouble(string.substring(2));
        return (double)n3 + d3 / 60.0;
    }

    protected double parseLongitude(int n2) {
        String string = this.getStringValue(n2);
        int n3 = Integer.parseInt(string.substring(0, 3));
        double d3 = Double.parseDouble(string.substring(3));
        return (double)n3 + d3 / 60.0;
    }

    protected Position parsePosition(int n2, int n3, int n4, int n5) {
        double d3 = ((PositionParser)((Object)compassPoint2)).parseLatitude(n2);
        double d4 = ((PositionParser)((Object)compassPoint2)).parseLongitude(n4);
        CompassPoint compassPoint = ((PositionParser)((Object)compassPoint2)).parseHemisphereLat(n3);
        CompassPoint compassPoint2 = ((PositionParser)((Object)compassPoint2)).parseHemisphereLon(n5);
        if (compassPoint.equals((Object)CompassPoint.SOUTH)) {
            d3 = -d3;
        }
        if (compassPoint2.equals((Object)CompassPoint.WEST)) {
            d4 = -d4;
        }
        return new Position(d3, d4);
    }

    protected void setLatHemisphere(int n2, CompassPoint compassPoint) {
        if (compassPoint != CompassPoint.NORTH && compassPoint != CompassPoint.SOUTH) {
            throw new IllegalArgumentException("Invalid latitude hemisphere: " + (Object)((Object)compassPoint));
        }
        this.setCharValue(n2, compassPoint.toChar());
    }

    protected void setLatitude(int n2, double d3) {
        DecimalFormat decimalFormat;
        double d4 = d3;
        int n3 = (int)Math.floor(d4);
        double d5 = (d4 - (double)n3) * 60.0;
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat("00.000");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n3;
        objectArray[1] = decimalFormat2.format(d5);
        this.setStringValue(n2, String.format("%02d%s", objectArray2));
    }

    protected void setLongitude(int n2, double d3) {
        DecimalFormat decimalFormat;
        double d4 = d3;
        int n3 = (int)Math.floor(d4);
        double d5 = (d4 - (double)n3) * 60.0;
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat("00.000");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n3;
        objectArray[1] = decimalFormat2.format(d5);
        this.setStringValue(n2, String.format("%03d%s", objectArray2));
    }

    protected void setLonHemisphere(int n2, CompassPoint compassPoint) {
        if (compassPoint != CompassPoint.EAST && compassPoint != CompassPoint.WEST) {
            throw new IllegalArgumentException("Invalid longitude hemisphere: " + (Object)((Object)compassPoint));
        }
        this.setCharValue(n2, compassPoint.toChar());
    }

    protected void setPositionValues(Position position, int n2, int n3, int n4, int n5) {
        this.setLatitude(n2, Math.abs(position.getLatitude()));
        this.setLongitude(n4, Math.abs(position.getLongitude()));
        this.setLatHemisphere(n3, position.getLatitudeHemisphere());
        this.setLonHemisphere(n5, position.getLongitudeHemisphere());
    }
}

