/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.parser;

import com.pop.android.common.util.nmea.parser.PositionParser;
import com.pop.android.common.util.nmea.parser.SentenceParser;
import com.pop.android.common.util.nmea.sentence.SentenceId;
import com.pop.android.common.util.nmea.sentence.TalkerId;
import com.pop.android.common.util.nmea.util.CompassPoint;
import com.pop.android.common.util.nmea.util.DataStatus;
import com.pop.android.common.util.nmea.util.FaaMode;
import com.pop.android.common.util.nmea.util.Position;
import com.pop.android.common.util.nmea.util.Time;
import java.util.Date;

public class RMCParser
extends PositionParser {
    private static final int UTC_TIME = 0;
    private static final int DATA_STATUS = 1;
    private static final int LATITUDE = 2;
    private static final int LAT_HEMISPHERE = 3;
    private static final int LONGITUDE = 4;
    private static final int LON_HEMISPHERE = 5;
    private static final int SPEED = 6;
    private static final int COURSE = 7;
    private static final int UTC_DATE = 8;
    private static final int MAG_VARIATION = 9;
    private static final int VAR_HEMISPHERE = 10;
    private static final int MODE = 11;

    public RMCParser(String string) {
        super(string, SentenceId.RMC);
    }

    public RMCParser(TalkerId talkerId) {
        super(talkerId, SentenceId.RMC, 12);
    }

    public double getCorrectedCourse() {
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            d3 = this.getCourse() + d4;
        }
        catch (Exception exception) {}
        try {
            d3 += this.getVariation();
        }
        catch (Exception exception) {}
        return d3;
    }

    public double getCourse() {
        return this.getDoubleValue(7);
    }

    public Date getDate() {
        return new Date(this.getStringValue(8));
    }

    public CompassPoint getDirectionOfVariation() {
        return CompassPoint.valueOf(this.getCharValue(10));
    }

    public FaaMode getMode() {
        return FaaMode.valueOf(this.getCharValue(11));
    }

    public Position getPosition() {
        return this.parsePosition(2, 3, 4, 5);
    }

    public double getSpeed() {
        return this.getDoubleValue(6);
    }

    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(1));
    }

    public Time getTime() {
        String string = ((SentenceParser)((Object)string)).getStringValue(0);
        return new Time(string);
    }

    public double getVariation() {
        double d3 = this.getDoubleValue(9);
        if (CompassPoint.EAST == this.getDirectionOfVariation() && d3 > 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public void setCourse(double d3) {
        this.setDegreesValue(7, d3);
    }

    public void setDate(Date date) {
        this.setStringValue(8, date.toString());
    }

    public void setDirectionOfVariation(CompassPoint compassPoint) {
        if (compassPoint != CompassPoint.EAST && compassPoint != CompassPoint.WEST) {
            throw new IllegalArgumentException("Invalid variation direction, expected EAST or WEST.");
        }
        this.setCharValue(10, compassPoint.toChar());
    }

    public void setMode(FaaMode faaMode) {
        this.setFieldCount(12);
        this.setCharValue(11, faaMode.toChar());
    }

    public void setPosition(Position position) {
        this.setPositionValues(position, 2, 3, 4, 5);
    }

    public void setSpeed(double d3) {
        this.setDoubleValue(6, d3, 1, 1);
    }

    public void setStatus(DataStatus dataStatus) {
        this.setCharValue(1, dataStatus.toChar());
    }

    public void setTime(Time time) {
        this.setStringValue(0, time.toString());
    }

    public void setVariation(double d3) {
        this.setDegreesValue(9, d3);
    }
}

