/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.util;

import com.pop.android.common.util.nmea.util.Time;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Date {
    private static final String DATE_PATTERN = "%d-%02d-%02d";
    public static final int PIVOT_YEAR = 50;
    private int day;
    private int month;
    private int year;

    public Date() {
        GregorianCalendar gregorianCalendar;
        GregorianCalendar gregorianCalendar2;
        GregorianCalendar gregorianCalendar3 = gregorianCalendar2 = gregorianCalendar;
        gregorianCalendar3();
        this.year = gregorianCalendar3.get(1);
        this.month = gregorianCalendar2.get(2) + 1;
        this.day = gregorianCalendar.get(5);
    }

    public Date(String string) {
        this.setDay(Integer.parseInt(string.substring(0, 2)));
        this.setMonth(Integer.parseInt(string.substring(2, 4)));
        this.setYear(Integer.parseInt(string.substring(4)));
    }

    public Date(int n2, int n3, int n4) {
        Date date = this;
        date.setYear(n2);
        date.setMonth(n3);
        date.setDay(n4);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof Date && ((Date)(object = (Date)object)).getDay() == this.getDay() && ((Date)object).getMonth() == this.getMonth() && ((Date)object).getYear() == this.getYear();
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        return this.toISO8601().hashCode();
    }

    public void setDay(int n2) {
        if (n2 > 0 && n2 <= 31) {
            this.day = n2;
            return;
        }
        throw new IllegalArgumentException("Day out of bounds [1..31]");
    }

    public void setMonth(int n2) {
        if (n2 > 0 && n2 <= 12) {
            this.month = n2;
            return;
        }
        throw new IllegalArgumentException("Month value out of bounds [1..12]");
    }

    public void setYear(int n2) {
        if (n2 >= 0 && (n2 <= 99 || n2 >= 1000) && n2 <= 9999) {
            if (n2 < 100 && n2 > 50) {
                this.year = n2 + 1900;
                return;
            }
            if (n2 < 100 && n2 <= 50) {
                this.year = n2 + 2000;
                return;
            }
            this.year = n2;
            return;
        }
        throw new IllegalArgumentException("Year must be two or four digit value");
    }

    public String toString() {
        String string = String.valueOf(this.getYear()).substring(2);
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getDay();
        objectArray[1] = this.getMonth();
        objectArray[2] = string;
        return String.format("%02d%02d%s", objectArray2);
    }

    public String toISO8601() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.getYear();
        objectArray2[1] = this.getMonth();
        objectArray[2] = this.getDay();
        return String.format(DATE_PATTERN, objectArray2);
    }

    public String toISO8601(Time time) {
        return this.toISO8601().concat("T").concat(time.toISO8601());
    }

    public java.util.Date toDate() {
        GregorianCalendar gregorianCalendar;
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        gregorianCalendar2(TimeZone.getTimeZone("UTC"));
        gregorianCalendar2.set(1, this.getYear());
        gregorianCalendar2.set(2, this.getMonth() - 1);
        gregorianCalendar.set(5, this.getDay());
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }
}

