/*
 * Decompiled with CFR 0.152.
 */
package com.pop.android.common.util.nmea.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Time {
    private static final String TIME_PATTERN = "%02d:%02d:%02d%+03d:%02d";
    private int hour;
    private int minutes;
    private double seconds;
    private int offsetHours;
    private int offsetMinutes;

    public Time() {
        GregorianCalendar gregorianCalendar;
        GregorianCalendar gregorianCalendar2;
        this.hour = 0;
        this.minutes = 0;
        this.seconds = 0.0;
        this.offsetHours = 0;
        this.offsetMinutes = 0;
        GregorianCalendar gregorianCalendar3 = gregorianCalendar2 = gregorianCalendar;
        gregorianCalendar3();
        this.hour = gregorianCalendar3.get(11);
        this.minutes = gregorianCalendar2.get(12);
        this.seconds = gregorianCalendar.get(13);
    }

    public Time(String string) {
        this.hour = 0;
        this.minutes = 0;
        this.seconds = 0.0;
        this.offsetHours = 0;
        this.offsetMinutes = 0;
        this.setHour(Integer.parseInt(string.substring(0, 2)));
        this.setMinutes(Integer.parseInt(string.substring(2, 4)));
        this.setSeconds(Double.parseDouble(string.substring(4)));
    }

    public Time(int n2, int n3, double d3) {
        Time time = this;
        time.hour = 0;
        time.minutes = 0;
        time.seconds = 0.0;
        time.offsetHours = 0;
        time.offsetMinutes = 0;
        time.setHour(n2);
        time.setMinutes(n3);
        time.setSeconds(d3);
    }

    public Time(int n2, int n3, double d3, int n4, int n5) {
        Time time = this;
        time.hour = 0;
        time.minutes = 0;
        time.seconds = 0.0;
        time.offsetHours = 0;
        time.offsetMinutes = 0;
        time.setHour(n2);
        time.setMinutes(n3);
        time.setSeconds(d3);
        time.setOffsetHours(n4);
        time.setOffsetMinutes(n5);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Time) {
            return ((Time)(object = (Time)object)).getHour() == this.getHour() && ((Time)object).getMinutes() == this.getMinutes() && ((Time)object).getSeconds() == this.getSeconds() && ((Time)object).getOffsetHours() == this.getOffsetHours() && ((Time)object).getOffsetMinutes() == this.getOffsetMinutes();
        }
        return false;
    }

    public int getHour() {
        return this.hour;
    }

    public long getMilliseconds() {
        return Math.round(this.getSeconds() * 1000.0) + (long)(this.getMinutes() * 60 * 1000) + (long)(this.getHour() * 3600 * 1000);
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getOffsetHours() {
        return this.offsetHours;
    }

    public int getOffsetMinutes() {
        return this.offsetMinutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int hashCode() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.hour;
        objectArray2[1] = this.minutes;
        objectArray[2] = this.seconds;
        return String.format("%2d%2d%2f", objectArray2).hashCode();
    }

    public void setHour(int n2) {
        if (n2 >= 0 && n2 <= 23) {
            this.hour = n2;
            return;
        }
        throw new IllegalArgumentException("Valid hour value is between 0..23");
    }

    public void setMinutes(int n2) {
        if (n2 >= 0 && n2 <= 59) {
            this.minutes = n2;
            return;
        }
        throw new IllegalArgumentException("Valid minutes value is between 0..59");
    }

    public void setOffsetHours(int n2) {
        if (n2 >= -13 && n2 <= 13) {
            this.offsetHours = n2;
            return;
        }
        throw new IllegalArgumentException("Offset out of bounds [-13..13]");
    }

    public void setOffsetMinutes(int n2) {
        if (n2 >= -59 && n2 <= 59) {
            this.offsetMinutes = n2;
            return;
        }
        throw new IllegalArgumentException("Offset out of bounds [-59..59]");
    }

    public void setSeconds(double d3) {
        if (!(d3 < 0.0) && !(d3 >= 60.0)) {
            this.seconds = d3;
            return;
        }
        throw new IllegalArgumentException("Invalid value for second (0 < seconds < 60)");
    }

    public void setTime(Date date) {
        GregorianCalendar gregorianCalendar;
        GregorianCalendar gregorianCalendar2;
        Time time = this;
        GregorianCalendar gregorianCalendar3 = gregorianCalendar2 = gregorianCalendar;
        gregorianCalendar2();
        gregorianCalendar3.setTime(date);
        double d3 = (double)gregorianCalendar3.get(13) + (double)gregorianCalendar2.get(14) / 1000.0;
        this.setHour(gregorianCalendar3.get(11));
        time.setMinutes(gregorianCalendar.get(12));
        time.setSeconds(d3);
    }

    public Date toDate(Date date) {
        GregorianCalendar gregorianCalendar;
        int n2 = (int)Math.floor(this.getSeconds());
        GregorianCalendar gregorianCalendar2 = gregorianCalendar;
        gregorianCalendar2(TimeZone.getTimeZone("UTC"));
        gregorianCalendar2.setTime(date);
        gregorianCalendar2.set(11, this.getHour());
        gregorianCalendar.set(12, this.getMinutes());
        gregorianCalendar.set(13, n2);
        gregorianCalendar.set(14, 0);
        return gregorianCalendar.getTime();
    }

    public String toString() {
        DecimalFormat decimalFormat;
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        object[0] = this.getHour();
        objectArray[1] = this.getMinutes();
        object = String.format("%02d%02d", object);
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat("00.000");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        return (String)object + decimalFormat2.format(this.getSeconds());
    }

    public String toISO8601() {
        Time time = this;
        int n2 = time.getHour();
        int n3 = time.getMinutes();
        int n4 = (int)Math.floor(time.getSeconds());
        int n5 = time.getOffsetHours();
        int n6 = time.getOffsetMinutes();
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray2[1] = n3;
        objectArray2[2] = n4;
        objectArray2[3] = n5;
        objectArray[4] = n6;
        return String.format(TIME_PATTERN, objectArray2);
    }
}

