/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson;

import com.qx.wz.external.fastjson.JSON;
import com.qx.wz.external.fastjson.JSONArray;
import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.annotation.JSONField;
import com.qx.wz.external.fastjson.parser.ParserConfig;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JSONObject
extends JSON
implements Serializable,
Cloneable,
InvocationHandler,
Map<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        this.map = map;
    }

    public JSONObject(boolean bl) {
        this(16, bl);
    }

    public JSONObject(int n2) {
        this(n2, false);
    }

    public JSONObject(int n2, boolean bl) {
        HashMap hashMap;
        Map<String, Object> map;
        if (bl) {
            LinkedHashMap linkedHashMap;
            JSONObject jSONObject = map;
            map = linkedHashMap;
            linkedHashMap = new LinkedHashMap(n2);
            jSONObject.map = map;
            return;
        }
        JSONObject jSONObject = map;
        map = hashMap;
        hashMap = new HashMap(n2);
        jSONObject.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        return this.map.get(object);
    }

    public JSONObject getJSONObject(String string) {
        Object object = ((JSONObject)object).map.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return (JSONObject)JSON.toJSON(object);
    }

    public JSONArray getJSONArray(String string) {
        Object object = ((JSONObject)object).map.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return (JSONArray)JSON.toJSON(object);
    }

    public <T> T getObject(String string, Class<T> clazz) {
        return TypeUtils.castToJavaBean(this.map.get(string), clazz);
    }

    public Boolean getBoolean(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return null;
        }
        return TypeUtils.castToBoolean(this);
    }

    public byte[] getBytes(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return null;
        }
        return TypeUtils.castToBytes(this);
    }

    public boolean getBooleanValue(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return false;
        }
        return TypeUtils.castToBoolean(this);
    }

    public Byte getByte(String string) {
        return TypeUtils.castToByte(this.get(string));
    }

    public byte getByteValue(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return 0;
        }
        return TypeUtils.castToByte(this);
    }

    public Short getShort(String string) {
        return TypeUtils.castToShort(this.get(string));
    }

    public short getShortValue(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return 0;
        }
        return TypeUtils.castToShort(this);
    }

    public Integer getInteger(String string) {
        return TypeUtils.castToInt(this.get(string));
    }

    public int getIntValue(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return 0;
        }
        return TypeUtils.castToInt(this);
    }

    public Long getLong(String string) {
        return TypeUtils.castToLong(this.get(string));
    }

    public long getLongValue(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return 0L;
        }
        return TypeUtils.castToLong(this);
    }

    public Float getFloat(String string) {
        return TypeUtils.castToFloat(this.get(string));
    }

    public float getFloatValue(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return 0.0f;
        }
        return TypeUtils.castToFloat(this).floatValue();
    }

    public Double getDouble(String string) {
        return TypeUtils.castToDouble(this.get(string));
    }

    public double getDoubleValue(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return 0.0;
        }
        return TypeUtils.castToDouble(this);
    }

    public BigDecimal getBigDecimal(String string) {
        return TypeUtils.castToBigDecimal(this.get(string));
    }

    public BigInteger getBigInteger(String string) {
        return TypeUtils.castToBigInteger(this.get(string));
    }

    public String getString(String string) {
        if ((this = ((JSONObject)this).get(string)) == null) {
            return null;
        }
        return this.toString();
    }

    public java.util.Date getDate(String string) {
        return TypeUtils.castToDate(this.get(string));
    }

    public Date getSqlDate(String string) {
        return TypeUtils.castToSqlDate(this.get(string));
    }

    public Timestamp getTimestamp(String string) {
        return TypeUtils.castToTimestamp(this.get(string));
    }

    @Override
    public Object put(String string, Object object) {
        return this.map.put(string, object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.map.putAll(map);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new JSONObject(new HashMap<String, Object>(this.map));
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object object, Method method, Object[] object2) {
        object = method.getParameterTypes();
        if (((Class<?>[])object).length == 1) {
            if (method.getName().equals("equals")) {
                return this.equals(object2[0]);
            }
            if (method.getReturnType() != Void.TYPE) throw new JSONException("illegal setter");
            object = null;
            JSONField jSONField = method.getAnnotation(JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                object = jSONField.name();
            }
            if (object == null) {
                object = method.getName();
                if (!((String)object).startsWith("set")) throw new JSONException("illegal setter");
                if (((String)(object = ((String)object).substring(3))).length() == 0) throw new JSONException("illegal setter");
                object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            }
            this.map.put((String)object, object2[0]);
            return null;
        }
        if (((Object)object).length != 0) throw new UnsupportedOperationException(method.toGenericString());
        if (method.getReturnType() == Void.TYPE) throw new JSONException("illegal getter");
        object = null;
        object2 = method.getAnnotation(JSONField.class);
        if (object2 != null && object2.name().length() != 0) {
            object = object2.name();
        }
        if (object != null) return TypeUtils.cast(this.map.get(object), method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        object = method.getName();
        if (((String)object).startsWith("get")) {
            if (((String)(object = ((String)object).substring(3))).length() == 0) throw new JSONException("illegal getter");
            object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            return TypeUtils.cast(this.map.get(object), method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        } else if (((String)object).startsWith("is")) {
            if (((String)(object = ((String)object).substring(2))).length() == 0) throw new JSONException("illegal getter");
            object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            return TypeUtils.cast(this.map.get(object), method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        } else {
            if (((String)object).startsWith("hashCode")) {
                return this.hashCode();
            }
            if (!((String)object).startsWith("toString")) throw new JSONException("illegal getter");
            return this.toString();
        }
    }
}

