/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson;

import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.JSONStreamContext;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import java.io.Closeable;
import java.io.Flushable;
import java.io.Writer;

public class JSONWriter
implements Closeable,
Flushable {
    private SerializeWriter writer;
    private JSONSerializer serializer;
    private JSONStreamContext context;

    public JSONWriter(Writer object) {
        JSONSerializer jSONSerializer;
        SerializeWriter serializeWriter;
        Closeable closeable = serializeWriter;
        serializeWriter = new SerializeWriter((Writer)object);
        v1.writer = closeable;
        object = jSONSerializer;
        jSONSerializer = new JSONSerializer((SerializeWriter)closeable);
        v1.serializer = object;
    }

    private void beginStructure() {
        int n2 = this.context.getState();
        switch (n2) {
            default: {
                throw new JSONException("illegal state : " + n2);
            }
            case 1005: {
                this.writer.write(',');
                return;
            }
            case 1004: {
                return;
            }
            case 1002: {
                this.writer.write(':');
                return;
            }
            case 1001: 
        }
    }

    private void endStructure() {
        JSONStreamContext jSONStreamContext;
        this.context = jSONStreamContext = this.context.getParent();
        if (jSONStreamContext == null) {
            return;
        }
        int n2 = -1;
        switch (jSONStreamContext.getState()) {
            default: {
                break;
            }
            case 1004: {
                n2 = 1005;
                break;
            }
            case 1002: {
                n2 = 1003;
                break;
            }
            case 1001: {
                n2 = 1002;
            }
        }
        if (n2 != -1) {
            this.context.setState(n2);
        }
    }

    private void beforeWrite() {
        JSONStreamContext jSONStreamContext = this.context;
        if (jSONStreamContext == null) {
            return;
        }
        switch (jSONStreamContext.getState()) {
            default: {
                break;
            }
            case 1005: {
                this.writer.write(',');
                break;
            }
            case 1003: {
                this.writer.write(',');
                return;
            }
            case 1002: {
                this.writer.write(':');
                return;
            }
        }
    }

    private void afterWriter() {
        JSONStreamContext jSONStreamContext = this.context;
        if (jSONStreamContext == null) {
            return;
        }
        int n2 = -1;
        switch (jSONStreamContext.getState()) {
            default: {
                break;
            }
            case 1004: {
                n2 = 1005;
                break;
            }
            case 1002: {
                n2 = 1003;
                break;
            }
            case 1001: 
            case 1003: {
                n2 = 1002;
            }
        }
        if (n2 != -1) {
            this.context.setState(n2);
        }
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        this.writer.config(serializerFeature, bl);
    }

    public void startObject() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, 1001);
        this.writer.write('{');
    }

    public void endObject() {
        JSONWriter jSONWriter = this;
        jSONWriter.writer.write('}');
        jSONWriter.endStructure();
    }

    public void writeKey(String string) {
        this.writeObject(string);
    }

    public void writeValue(Object object) {
        this.writeObject(object);
    }

    public void writeObject(String string) {
        JSONWriter jSONWriter = this;
        jSONWriter.beforeWrite();
        jSONWriter.serializer.write(string);
        jSONWriter.afterWriter();
    }

    public void writeObject(Object object) {
        JSONWriter jSONWriter = this;
        jSONWriter.beforeWrite();
        jSONWriter.serializer.write(object);
        jSONWriter.afterWriter();
    }

    public void startArray() {
        if (this.context != null) {
            this.beginStructure();
        }
        this.context = new JSONStreamContext(this.context, 1004);
        this.writer.write('[');
    }

    public void endArray() {
        JSONWriter jSONWriter = this;
        jSONWriter.writer.write(']');
        jSONWriter.endStructure();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

