/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.parser;

import com.qx.wz.external.fastjson.JSON;
import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.parser.Feature;
import com.qx.wz.external.fastjson.parser.JSONLexer;
import com.qx.wz.external.fastjson.parser.JSONToken;
import com.qx.wz.external.fastjson.parser.SymbolTable;
import com.qx.wz.external.fastjson.util.IOUtils;
import java.io.Closeable;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    private static final Map<String, Integer> DEFAULT_KEYWORDS;
    private static final ThreadLocal<SoftReference<char[]>> SBUF_REF_LOCAL;
    protected static final char[] typeFieldName;
    protected static boolean[] whitespaceFlags;
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int INT_N_MULTMAX_RADIX_TEN = -214748364;
    protected static final int[] digits;
    protected int token;
    protected int pos;
    protected int features = JSON.DEFAULT_PARSER_FEATURE;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    public int matchStat = 0;
    protected Map<String, Integer> keywods = DEFAULT_KEYWORDS;

    public JSONLexerBase() {
        SoftReference<char[]> softReference = SBUF_REF_LOCAL.get();
        if (softReference != null) {
            this.sbuf = softReference.get();
            SBUF_REF_LOCAL.set(null);
        }
        if (this.sbuf == null) {
            this.sbuf = new char[64];
        }
    }

    private final void scanStringSingleQuote() {
        char c3;
        this.np = this.bp;
        this.hasSpecial = false;
        block26: while ((c3 = this.next()) != '\'') {
            if (c3 != '\u001a') {
                char n2;
                Object[] objectArray;
                if (c3 == '\\') {
                    if (!this.hasSpecial) {
                        this.hasSpecial = true;
                        int cArray2 = this.sp;
                        char[] cArray = this.sbuf;
                        if (cArray2 > this.sbuf.length) {
                            char[] cArray3 = new char[cArray2 << 1];
                            int n3 = cArray.length;
                            System.arraycopy(cArray, 0, cArray3, 0, n3);
                            this.sbuf = cArray3;
                        }
                        JSONLexerBase jSONLexerBase = this;
                        int n4 = jSONLexerBase.np + 1;
                        int n5 = jSONLexerBase.sp;
                        objectArray = jSONLexerBase.sbuf;
                        jSONLexerBase.copyTo(n4, n5, (char[])objectArray);
                    }
                    c3 = this.next();
                    switch (c3) {
                        default: {
                            switch (c3) {
                                default: {
                                    switch (c3) {
                                        default: {
                                            this.ch = c3;
                                            throw new JSONException("unclosed single-quote string");
                                        }
                                        case 'v': {
                                            this.putChar('\u000b');
                                            continue block26;
                                        }
                                        case 'u': {
                                            JSONLexerBase jSONLexerBase = this;
                                            c3 = jSONLexerBase.next();
                                            n2 = jSONLexerBase.next();
                                            char c4 = jSONLexerBase.next();
                                            char c5 = jSONLexerBase.next();
                                            jSONLexerBase.putChar((char)Integer.parseInt(new String(new char[]{c3, n2, c4, c5}), 16));
                                            continue block26;
                                        }
                                        case 't': 
                                    }
                                    this.putChar('\t');
                                    continue block26;
                                }
                                case '7': {
                                    this.putChar('\u0007');
                                    continue block26;
                                }
                                case '6': {
                                    this.putChar('\u0006');
                                    continue block26;
                                }
                                case '5': {
                                    this.putChar('\u0005');
                                    continue block26;
                                }
                                case '4': {
                                    this.putChar('\u0004');
                                    continue block26;
                                }
                                case '3': {
                                    this.putChar('\u0003');
                                    continue block26;
                                }
                                case '2': {
                                    this.putChar('\u0002');
                                    continue block26;
                                }
                                case '1': {
                                    this.putChar('\u0001');
                                    continue block26;
                                }
                                case '0': {
                                    this.putChar('\u0000');
                                    continue block26;
                                }
                                case '/': 
                            }
                            this.putChar('/');
                            continue block26;
                        }
                        case 'x': {
                            JSONLexerBase jSONLexerBase = this;
                            c3 = jSONLexerBase.next();
                            n2 = jSONLexerBase.next();
                            objectArray = digits;
                            jSONLexerBase.putChar((char)((digits[c3] << 4) + objectArray[n2]));
                            continue block26;
                        }
                        case 'r': {
                            this.putChar('\r');
                            continue block26;
                        }
                        case 'n': {
                            this.putChar('\n');
                            continue block26;
                        }
                        case 'b': {
                            this.putChar('\b');
                            continue block26;
                        }
                        case '\\': {
                            this.putChar('\\');
                            continue block26;
                        }
                        case 'F': 
                        case 'f': {
                            this.putChar('\f');
                            continue block26;
                        }
                        case '\'': {
                            this.putChar('\'');
                            continue block26;
                        }
                        case '\"': 
                    }
                    this.putChar('\"');
                    continue;
                }
                if (!this.hasSpecial) {
                    ++this.sp;
                    continue;
                }
                n2 = this.sp;
                objectArray = this.sbuf;
                if (n2 == this.sbuf.length) {
                    this.putChar(c3);
                    continue;
                }
                this.sp = n2 + 1;
                objectArray[n2] = c3;
                continue;
            }
            throw new JSONException("unclosed single-quote string");
        }
        this.token = 4;
        this.next();
    }

    public static final boolean isWhitespace(char c3) {
        return c3 == ' ' || c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == '\f' || c3 == '\b';
        {
        }
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("null", 8);
        hashMap.put("new", 9);
        hashMap.put("true", 6);
        hashMap.put("false", 7);
        hashMap.put("undefined", 23);
        DEFAULT_KEYWORDS = hashMap;
        SBUF_REF_LOCAL = new ThreadLocal();
        typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
        boolean[] blArray = new boolean[256];
        whitespaceFlags = blArray;
        blArray[32] = true;
        blArray[10] = true;
        blArray[13] = true;
        blArray[9] = true;
        blArray[12] = true;
        blArray[8] = true;
        digits = new int[103];
        int n2 = 48;
        while (n2 <= 57) {
            int n3 = n2++;
            JSONLexerBase.digits[n3] = n3 - 48;
        }
        n2 = 97;
        while (n2 <= 102) {
            int n4 = n2++;
            JSONLexerBase.digits[n4] = n4 - 97 + 10;
        }
        n2 = 65;
        while (n2 <= 70) {
            int n5 = n2++;
            JSONLexerBase.digits[n5] = n5 - 65 + 10;
        }
    }

    protected void lexError(String string, Object ... objectArray) {
        this.token = 1;
    }

    @Override
    public final void nextToken() {
        block24: {
            this.sp = 0;
            block17: while (true) {
                JSONLexerBase jSONLexerBase = this;
                jSONLexerBase.pos = jSONLexerBase.bp;
                char c3 = jSONLexerBase.ch;
                if (c3 == '\"') {
                    this.scanString();
                    return;
                }
                if (c3 == ',') {
                    this.next();
                    this.token = 16;
                    return;
                }
                if (c3 >= '0' && c3 <= '9') {
                    this.scanNumber();
                    return;
                }
                c3 = this.ch;
                if (c3 == '-') {
                    this.scanNumber();
                    return;
                }
                switch (c3) {
                    default: {
                        if (this.isEOF()) {
                            int n2;
                            if (this.token == 20) break block17;
                            this.token = 20;
                            this.bp = n2 = this.eofPos;
                            this.pos = n2;
                            return;
                        }
                        break block24;
                    }
                    case '}': {
                        this.next();
                        this.token = 13;
                        return;
                    }
                    case '{': {
                        this.next();
                        this.token = 12;
                        return;
                    }
                    case 'u': {
                        this.scanUndefined();
                        return;
                    }
                    case 't': {
                        this.scanTrue();
                        return;
                    }
                    case 'n': {
                        this.scanNullOrNew();
                        return;
                    }
                    case 'f': {
                        this.scanFalse();
                        return;
                    }
                    case ']': {
                        this.next();
                        this.token = 15;
                        return;
                    }
                    case '[': {
                        this.next();
                        this.token = 14;
                        return;
                    }
                    case 'T': {
                        this.scanTreeSet();
                        return;
                    }
                    case 'S': {
                        this.scanSet();
                        return;
                    }
                    case ':': {
                        this.next();
                        this.token = 17;
                        return;
                    }
                    case ')': {
                        this.next();
                        this.token = 11;
                        return;
                    }
                    case '(': {
                        this.next();
                        this.token = 10;
                        return;
                    }
                    case '\'': {
                        if (this.isEnabled(Feature.AllowSingleQuotes)) {
                            this.scanStringSingleQuote();
                            return;
                        }
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.next();
                        continue block17;
                    }
                }
                break;
            }
            throw new JSONException("EOF error");
        }
        JSONLexerBase jSONLexerBase = this;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = String.valueOf((int)this.ch);
        jSONLexerBase.lexError("illegal.char", objectArray2);
        jSONLexerBase.next();
    }

    @Override
    public final void nextToken(int n2) {
        this.sp = 0;
        while (true) {
            char c3;
            block29: {
                block24: {
                    block25: {
                        block26: {
                            block27: {
                                block28: {
                                    if (n2 == 2) break block24;
                                    if (n2 == 4) break block25;
                                    if (n2 == 12) break block26;
                                    if (n2 == 18) break block27;
                                    if (n2 == 20) break block28;
                                    switch (n2) {
                                        default: {
                                            break block29;
                                        }
                                        case 16: {
                                            c3 = this.ch;
                                            if (c3 == ',') {
                                                this.token = 16;
                                                this.next();
                                                return;
                                            }
                                            if (c3 == '}') {
                                                this.token = 13;
                                                this.next();
                                                return;
                                            }
                                            if (c3 == ']') {
                                                this.token = 15;
                                                this.next();
                                                return;
                                            }
                                            if (c3 == '\u001a') {
                                                this.token = 20;
                                                return;
                                            }
                                            break block29;
                                        }
                                        case 15: {
                                            if (this.ch != ']') break;
                                            this.token = 15;
                                            this.next();
                                            return;
                                        }
                                        case 14: {
                                            c3 = this.ch;
                                            if (c3 == '[') {
                                                this.token = 14;
                                                this.next();
                                                return;
                                            }
                                            if (c3 == '{') {
                                                this.token = 12;
                                                this.next();
                                                return;
                                            }
                                            break block29;
                                        }
                                    }
                                }
                                if (this.ch == '\u001a') {
                                    this.token = 20;
                                    return;
                                }
                                break block29;
                            }
                            this.nextIdent();
                            return;
                        }
                        c3 = this.ch;
                        if (c3 == '{') {
                            this.token = 12;
                            this.next();
                            return;
                        }
                        if (c3 == '[') {
                            this.token = 14;
                            this.next();
                            return;
                        }
                        break block29;
                    }
                    c3 = this.ch;
                    if (c3 == '\"') {
                        JSONLexerBase jSONLexerBase = this;
                        jSONLexerBase.pos = jSONLexerBase.bp;
                        jSONLexerBase.scanString();
                        return;
                    }
                    if (c3 >= '0' && c3 <= '9') {
                        JSONLexerBase jSONLexerBase = this;
                        jSONLexerBase.pos = jSONLexerBase.bp;
                        jSONLexerBase.scanNumber();
                        return;
                    }
                    c3 = this.ch;
                    if (c3 == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (c3 == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    break block29;
                }
                c3 = this.ch;
                if (c3 >= '0' && c3 <= '9') {
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.pos = jSONLexerBase.bp;
                    jSONLexerBase.scanNumber();
                    return;
                }
                c3 = this.ch;
                if (c3 == '\"') {
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.pos = jSONLexerBase.bp;
                    jSONLexerBase.scanString();
                    return;
                }
                if (c3 == '[') {
                    this.token = 14;
                    this.next();
                    return;
                }
                if (c3 == '{') {
                    this.token = 12;
                    this.next();
                    return;
                }
            }
            c3 = this.ch;
            if (c3 != ' ' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\f' && c3 != '\b') {
                this.nextToken();
                return;
            }
            this.next();
        }
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.ch)) {
            this.next();
        }
        char c3 = this.ch;
        if (c3 != '_' && !Character.isLetter(c3)) {
            this.nextToken();
            return;
        }
        this.scanIdent();
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c3) {
        this.sp = 0;
        while (true) {
            char c4;
            if ((c4 = this.ch) == c3) {
                JSONLexerBase jSONLexerBase = this;
                jSONLexerBase.next();
                jSONLexerBase.nextToken();
                return;
            }
            if (c4 != ' ' && c4 != '\n' && c4 != '\r' && c4 != '\t' && c4 != '\f' && c4 != '\b') {
                throw new JSONException("not match " + c3 + " - " + this.ch);
            }
            this.next();
        }
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    @Override
    public final int getBufferPosition() {
        return this.bp;
    }

    public final String stringDefaultValue() {
        if (this.isEnabled(Feature.InitStringFieldAsEmpty)) {
            return "";
        }
        return null;
    }

    @Override
    public final Number integerValue() {
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        JSONLexerBase jSONLexerBase = this;
        int n2 = jSONLexerBase.np;
        int n3 = n2 + this.sp;
        int n4 = 32;
        char c3 = jSONLexerBase.charAt(n3 - 1);
        if (c3 != 'B') {
            if (c3 != 'L') {
                if (c3 == 'S') {
                    --n3;
                    n4 = 83;
                }
            } else {
                --n3;
                n4 = 76;
            }
        } else {
            --n3;
            n4 = 66;
        }
        JSONLexerBase jSONLexerBase2 = this;
        if (jSONLexerBase2.charAt(jSONLexerBase2.np) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n2;
        } else {
            l2 = -9223372036854775807L;
        }
        if (n2 < n3) {
            l3 = -digits[this.charAt(n2++)];
        }
        while (n2 < n3) {
            int n5 = digits[this.charAt(n2++)];
            if (l3 < -922337203685477580L) {
                return new BigInteger(this.numberString());
            }
            long l4 = n5;
            if ((l3 *= 10L) < l2 + l4) {
                return new BigInteger(this.numberString());
            }
            l3 -= l4;
        }
        if (bl) {
            if (n2 > this.np + 1) {
                if (l3 >= Integer.MIN_VALUE && n4 != 76) {
                    if (n4 == 83) {
                        return (short)l3;
                    }
                    if (n4 == 66) {
                        return (byte)l3;
                    }
                    return (int)l3;
                }
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l3 = -l3) <= Integer.MAX_VALUE && n4 != 76) {
            if (n4 == 83) {
                return (short)l3;
            }
            if (n4 == 66) {
                return (byte)l3;
            }
            return (int)l3;
        }
        return l3;
    }

    @Override
    public final void nextTokenWithColon(int n2) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.numberString());
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void config(Feature feature, boolean bl) {
        this.features = Feature.config(this.features, feature, bl);
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return Feature.isEnabled(this.features, feature);
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.skipWhitespace();
        char c3 = jSONLexerBase.ch;
        if (c3 == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (c3 == '\'') {
            if (this.isEnabled(Feature.AllowSingleQuotes)) {
                return this.scanSymbol(symbolTable, '\'');
            }
            throw new JSONException("syntax error");
        }
        if (c3 == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (c3 == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (c3 == '\u001a') {
            this.token = 20;
            return null;
        }
        if (this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            return this.scanSymbolUnQuoted(symbolTable);
        }
        throw new JSONException("syntax error");
    }

    protected abstract void arrayCopy(int var1, char[] var2, int var3, int var4);

    /*
     * Could not resolve type clashes
     */
    @Override
    public final String scanSymbol(SymbolTable object, char c3) {
        String string;
        char c4;
        char c5 = '\u0000';
        this.np = this.bp;
        this.sp = 0;
        boolean bl = false;
        block26: while ((c4 = this.next()) != c3) {
            if (c4 != '\u001a') {
                if (c4 == '\\') {
                    char c6;
                    Object[] objectArray;
                    if (!bl) {
                        bl = true;
                        c4 = this.sp;
                        objectArray = this.sbuf;
                        if (c4 >= this.sbuf.length) {
                            char c7 = objectArray.length << 1;
                            if (c4 > c7) {
                                c7 = c4;
                            }
                            JSONLexerBase jSONLexerBase = this;
                            char[] cArray = new char[c7];
                            c7 = jSONLexerBase.sbuf.length;
                            System.arraycopy(jSONLexerBase.sbuf, 0, cArray, 0, c7);
                            jSONLexerBase.sbuf = cArray;
                        }
                        JSONLexerBase jSONLexerBase = this;
                        c4 = jSONLexerBase.np + 1;
                        objectArray = jSONLexerBase.sbuf;
                        c6 = jSONLexerBase.sp;
                        jSONLexerBase.arrayCopy(c4, (char[])objectArray, 0, c6);
                    }
                    c4 = this.next();
                    block0 : switch (c4) {
                        default: {
                            switch (c4) {
                                default: {
                                    switch (c4) {
                                        default: {
                                            this.ch = c4;
                                            throw new JSONException("unclosed.str.lit");
                                        }
                                        case 'v': {
                                            c5 = c5 * 31 + 11;
                                            this.putChar('\u000b');
                                            continue block26;
                                        }
                                        case 'u': {
                                            char c8 = c5;
                                            JSONLexerBase jSONLexerBase = this;
                                            c5 = jSONLexerBase.next();
                                            c4 = jSONLexerBase.next();
                                            char c9 = jSONLexerBase.next();
                                            c6 = jSONLexerBase.next();
                                            c5 = Integer.parseInt(new String(new char[]{c5, c4, c9, c6}), 16);
                                            c4 = c8 * 31 + c5;
                                            this.putChar(c5);
                                            break block0;
                                        }
                                        case 't': 
                                    }
                                    c4 = c5 * 31 + 9;
                                    this.putChar('\t');
                                    break block0;
                                }
                                case '7': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0007');
                                    break block0;
                                }
                                case '6': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0006');
                                    break block0;
                                }
                                case '5': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0005');
                                    break block0;
                                }
                                case '4': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0004');
                                    break block0;
                                }
                                case '3': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0003');
                                    break block0;
                                }
                                case '2': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0002');
                                    break block0;
                                }
                                case '1': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0001');
                                    break block0;
                                }
                                case '0': {
                                    c4 = c5 * 31 + c4;
                                    this.putChar('\u0000');
                                    break block0;
                                }
                                case '/': 
                            }
                            c4 = c5 * 31 + 47;
                            this.putChar('/');
                            break;
                        }
                        case 'x': {
                            char c10 = c5;
                            JSONLexerBase jSONLexerBase = this;
                            c5 = jSONLexerBase.next();
                            jSONLexerBase.ch = jSONLexerBase.ch;
                            c4 = jSONLexerBase.next();
                            jSONLexerBase.ch = jSONLexerBase.ch;
                            objectArray = digits;
                            c5 = (char)((digits[c5] << 4) + objectArray[c4]);
                            c4 = c10 * 31 + c5;
                            this.putChar(c5);
                            break;
                        }
                        case 'r': {
                            c4 = c5 * 31 + 13;
                            this.putChar('\r');
                            break;
                        }
                        case 'n': {
                            c4 = c5 * 31 + 10;
                            this.putChar('\n');
                            break;
                        }
                        case 'b': {
                            c4 = c5 * 31 + 8;
                            this.putChar('\b');
                            break;
                        }
                        case '\\': {
                            c4 = c5 * 31 + 92;
                            this.putChar('\\');
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            c4 = c5 * 31 + 12;
                            this.putChar('\f');
                            break;
                        }
                        case '\'': {
                            c4 = c5 * 31 + 39;
                            this.putChar('\'');
                            break;
                        }
                        case '\"': {
                            c4 = c5 * 31 + 34;
                            this.putChar('\"');
                        }
                    }
                    c5 = c4;
                    continue;
                }
                c5 = c5 * 31 + c4;
                if (!bl) {
                    ++this.sp;
                    continue;
                }
                int n2 = this.sp;
                char[] cArray = this.sbuf;
                if (n2 == this.sbuf.length) {
                    this.putChar(c4);
                    continue;
                }
                this.sp = n2 + 1;
                cArray[n2] = c4;
                continue;
            }
            throw new JSONException("unclosed.str");
        }
        this.token = 4;
        if (!bl) {
            int n3 = this.np;
            c3 = (char)n3;
            c3 = n3 == -1 ? (char)'\u0000' : (char)(c3 + 1);
            JSONLexerBase jSONLexerBase = this;
            string = jSONLexerBase.addSymbol(c3, jSONLexerBase.sp, c5, (SymbolTable)object);
        } else {
            SymbolTable symbolTable = object;
            JSONLexerBase jSONLexerBase = this;
            object = jSONLexerBase.sbuf;
            c3 = (char)jSONLexerBase.sp;
            string = symbolTable.addSymbol((char[])object, 0, (int)c3, (int)c5);
        }
        this.sp = 0;
        this.next();
        return string;
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        int n2 = this.ch;
        boolean[] blArray = IOUtils.firstIdentifierFlags;
        boolean bl = n2 >= blArray.length || blArray[n2];
        if (bl) {
            blArray = IOUtils.identifierFlags;
            this.np = this.bp;
            this.sp = 1;
            while (true) {
                char c3;
                if ((c3 = this.next()) < blArray.length && !blArray[c3]) {
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.ch = jSONLexerBase.charAt(jSONLexerBase.bp);
                    jSONLexerBase.token = 18;
                    if (jSONLexerBase.sp == 4 && n2 == 3392903) {
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.np) == 'n') {
                            JSONLexerBase jSONLexerBase3 = this;
                            if (jSONLexerBase3.charAt(jSONLexerBase3.np + 1) == 'u') {
                                JSONLexerBase jSONLexerBase4 = this;
                                if (jSONLexerBase4.charAt(jSONLexerBase4.np + 2) == 'l') {
                                    JSONLexerBase jSONLexerBase5 = this;
                                    if (jSONLexerBase5.charAt(jSONLexerBase5.np + 3) == 'l') {
                                        return null;
                                    }
                                }
                            }
                        }
                    }
                    JSONLexerBase jSONLexerBase6 = this;
                    int n3 = jSONLexerBase6.np;
                    return jSONLexerBase6.addSymbol(n3, jSONLexerBase6.sp, n2, symbolTable);
                }
                n2 = n2 * 31 + c3;
                ++this.sp;
            }
        }
        throw new JSONException("illegal identifier : " + this.ch);
    }

    protected abstract void copyTo(int var1, int var2, char[] var3);

    @Override
    public final void scanString() {
        char c3;
        this.np = this.bp;
        this.hasSpecial = false;
        block26: while ((c3 = this.next()) != '\"') {
            if (c3 != '\u001a') {
                char c5;
                Object[] objectArray;
                if (c3 == '\\') {
                    if (!this.hasSpecial) {
                        this.hasSpecial = true;
                        int cArray2 = this.sp;
                        char[] cArray = this.sbuf;
                        if (cArray2 >= this.sbuf.length) {
                            int n2;
                            int n3 = cArray.length << 1;
                            if (cArray2 > n3) {
                                n2 = cArray2;
                            }
                            JSONLexerBase jSONLexerBase = this;
                            char[] cArray3 = new char[n2];
                            int n4 = jSONLexerBase.sbuf.length;
                            System.arraycopy(jSONLexerBase.sbuf, 0, cArray3, 0, n4);
                            jSONLexerBase.sbuf = cArray3;
                        }
                        JSONLexerBase jSONLexerBase = this;
                        int n5 = jSONLexerBase.np + 1;
                        int n6 = jSONLexerBase.sp;
                        objectArray = jSONLexerBase.sbuf;
                        jSONLexerBase.copyTo(n5, n6, (char[])objectArray);
                    }
                    c3 = this.next();
                    switch (c3) {
                        default: {
                            switch (c3) {
                                default: {
                                    switch (c3) {
                                        default: {
                                            this.ch = c3;
                                            throw new JSONException("unclosed string : " + c3);
                                        }
                                        case 'v': {
                                            this.putChar('\u000b');
                                            continue block26;
                                        }
                                        case 'u': {
                                            JSONLexerBase jSONLexerBase = this;
                                            c3 = jSONLexerBase.next();
                                            c5 = jSONLexerBase.next();
                                            char c4 = jSONLexerBase.next();
                                            char c6 = jSONLexerBase.next();
                                            jSONLexerBase.putChar((char)Integer.parseInt(new String(new char[]{c3, c5, c4, c6}), 16));
                                            continue block26;
                                        }
                                        case 't': 
                                    }
                                    this.putChar('\t');
                                    continue block26;
                                }
                                case '7': {
                                    this.putChar('\u0007');
                                    continue block26;
                                }
                                case '6': {
                                    this.putChar('\u0006');
                                    continue block26;
                                }
                                case '5': {
                                    this.putChar('\u0005');
                                    continue block26;
                                }
                                case '4': {
                                    this.putChar('\u0004');
                                    continue block26;
                                }
                                case '3': {
                                    this.putChar('\u0003');
                                    continue block26;
                                }
                                case '2': {
                                    this.putChar('\u0002');
                                    continue block26;
                                }
                                case '1': {
                                    this.putChar('\u0001');
                                    continue block26;
                                }
                                case '0': {
                                    this.putChar('\u0000');
                                    continue block26;
                                }
                                case '/': 
                            }
                            this.putChar('/');
                            continue block26;
                        }
                        case 'x': {
                            JSONLexerBase jSONLexerBase = this;
                            c3 = jSONLexerBase.next();
                            c5 = jSONLexerBase.next();
                            objectArray = digits;
                            jSONLexerBase.putChar((char)((digits[c3] << 4) + objectArray[c5]));
                            continue block26;
                        }
                        case 'r': {
                            this.putChar('\r');
                            continue block26;
                        }
                        case 'n': {
                            this.putChar('\n');
                            continue block26;
                        }
                        case 'b': {
                            this.putChar('\b');
                            continue block26;
                        }
                        case '\\': {
                            this.putChar('\\');
                            continue block26;
                        }
                        case 'F': 
                        case 'f': {
                            this.putChar('\f');
                            continue block26;
                        }
                        case '\'': {
                            this.putChar('\'');
                            continue block26;
                        }
                        case '\"': 
                    }
                    this.putChar('\"');
                    continue;
                }
                if (!this.hasSpecial) {
                    ++this.sp;
                    continue;
                }
                c5 = this.sp;
                objectArray = this.sbuf;
                if (c5 == this.sbuf.length) {
                    this.putChar(c3);
                    continue;
                }
                this.sp = c5 + 1;
                objectArray[c5] = c3;
                continue;
            }
            throw new JSONException("unclosed string : " + c3);
        }
        this.token = 4;
        this.ch = this.next();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public final int intValue() {
        int n2;
        boolean bl;
        int n3;
        block10: {
            int n4;
            if (this.np == -1) {
                this.np = 0;
            }
            JSONLexerBase jSONLexerBase = this;
            n3 = 0;
            bl = false;
            int n5 = jSONLexerBase.np;
            int n6 = n5 + this.sp;
            if (jSONLexerBase.charAt(n5) == '-') {
                bl = true;
                n4 = Integer.MIN_VALUE;
                ++n5;
            } else {
                n4 = -2147483647;
            }
            if (n5 < n6) {
                n3 = -digits[this.charAt(n5++)];
            }
            while (n5 < n6) {
                n2 = n5 + 1;
                char c3 = this.charAt(n5);
                n5 = c3;
                if (c3 != 'L' && n5 != 83 && n5 != 66) {
                    n5 = digits[n5];
                    if (n3 >= -214748364) {
                        if ((n3 *= 10) >= n4 + n5) {
                            n3 -= n5;
                            n5 = n2;
                            continue;
                        }
                        throw new NumberFormatException(this.numberString());
                    }
                    throw new NumberFormatException(this.numberString());
                }
                break block10;
            }
            n2 = n5;
        }
        if (bl) {
            if (n2 > this.np + 1) {
                return n3;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n3;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            SBUF_REF_LOCAL.set(new SoftReference<char[]>(this.sbuf));
        }
        this.sbuf = null;
    }

    @Override
    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np + 1) == '$') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.np + 2) == 'r') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.np + 3) == 'e') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.np + 4) == 'f') {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    @Override
    public String scanString(char c3) {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.matchStat = 0;
        int n2 = jSONLexerBase.charAt(jSONLexerBase.bp);
        if (n2 == 110) {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 1) == 'u') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 1 + 1) == 'l') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.bp + 1 + 2) == 'l') {
                        JSONLexerBase jSONLexerBase5 = this;
                        if (jSONLexerBase5.charAt(jSONLexerBase5.bp + 4) == c3) {
                            JSONLexerBase jSONLexerBase6 = this;
                            jSONLexerBase6.bp += 4;
                            jSONLexerBase6.next();
                            jSONLexerBase6.matchStat = 3;
                            return null;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        if (n2 != 34) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        JSONLexerBase jSONLexerBase7 = this;
        n2 = 0;
        int n3 = jSONLexerBase7.bp + 1;
        int n4 = jSONLexerBase7.indexOf('\"', n3);
        if (n4 != -1) {
            int n5 = n3;
            n3 = this.bp + 1;
            String string = this.subString(n3, n4 - n5);
            for (int i3 = (v175479).bp + 1; i3 < n4; ++i3) {
                if (this.charAt(i3) != '\\') continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            JSONLexerBase jSONLexerBase8 = this;
            int n6 = jSONLexerBase8.bp;
            int n7 = n4 - (n6 + 1) + 1 + 1;
            n2 = n7 + 1;
            if (jSONLexerBase8.charAt(n6 + n7) == c3) {
                JSONLexerBase jSONLexerBase9 = this;
                jSONLexerBase9.bp += n2 - 1;
                jSONLexerBase9.next();
                jSONLexerBase9.matchStat = 3;
                return string;
            }
            this.matchStat = -1;
            return string;
        }
        throw new JSONException("unclosed str");
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable symbolTable, char c3) {
        if ((this = ((JSONLexerBase)this).scanSymbolWithSeperator(symbolTable, c3)) == null) {
            return null;
        }
        return Enum.valueOf(clazz, (String)this);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable object, char c3) {
        int n2;
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.matchStat = 0;
        int n3 = 1;
        int n4 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
        if (n4 == 110) {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 1) == 'u') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 1 + 1) == 'l') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.bp + 1 + 2) == 'l') {
                        JSONLexerBase jSONLexerBase5 = this;
                        if (jSONLexerBase5.charAt(jSONLexerBase5.bp + 4) == c3) {
                            JSONLexerBase jSONLexerBase6 = this;
                            jSONLexerBase6.bp += 4;
                            jSONLexerBase6.next();
                            jSONLexerBase6.matchStat = 3;
                            return null;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        if (n4 != 34) {
            this.matchStat = -1;
            return null;
        }
        n4 = 0;
        do {
            JSONLexerBase jSONLexerBase7 = this;
            if ((n2 = jSONLexerBase7.charAt(jSONLexerBase7.bp + n3++)) == 34) {
                JSONLexerBase jSONLexerBase8 = this;
                int n5 = jSONLexerBase8.bp;
                n2 = n5 + 1;
                object = jSONLexerBase8.addSymbol(n2, n5 + n3 - n2 - 1, n4, (SymbolTable)object);
                if (jSONLexerBase8.charAt(jSONLexerBase8.bp + n3++) == c3) {
                    JSONLexerBase jSONLexerBase9 = this;
                    jSONLexerBase9.bp += n3 - 1;
                    jSONLexerBase9.next();
                    jSONLexerBase9.matchStat = 3;
                    return object;
                }
                this.matchStat = -1;
                return object;
            }
            n4 = n4 * 31 + n2;
        } while (n2 != 92);
        this.matchStat = -1;
        return null;
    }

    @Override
    public int scanInt(char c3) {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.matchStat = 0;
        int n2 = 1;
        int n3 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
        if (n3 >= 48 && n3 <= 57) {
            char c4;
            n3 = digits[n3];
            while (true) {
                JSONLexerBase jSONLexerBase2 = this;
                if ((c4 = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++)) < '0' || c4 > '9') break;
                n3 = n3 * 10 + digits[c4];
            }
            if (c4 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n3 < 0) {
                this.matchStat = -1;
                return 0;
            }
            if (c4 == c3) {
                JSONLexerBase jSONLexerBase3 = this;
                jSONLexerBase3.bp += n2 - 1;
                jSONLexerBase3.next();
                jSONLexerBase3.matchStat = 3;
                jSONLexerBase3.token = 16;
                return n3;
            }
            this.matchStat = -1;
            return n3;
        }
        this.matchStat = -1;
        return 0;
    }

    @Override
    public long scanLong(char c3) {
        JSONLexerBase jSONLexerBase = this;
        jSONLexerBase.matchStat = 0;
        int n2 = 1;
        char c4 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
        if (c4 >= '0' && c4 <= '9') {
            char c5;
            long l2 = digits[c4];
            while (true) {
                JSONLexerBase jSONLexerBase2 = this;
                if ((c5 = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++)) < '0' || c5 > '9') break;
                l2 = l2 * 10L + (long)digits[c5];
            }
            if (c5 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (l2 < 0L) {
                this.matchStat = -1;
                return 0L;
            }
            if (c5 == c3) {
                JSONLexerBase jSONLexerBase3 = this;
                jSONLexerBase3.bp += n2 - 1;
                jSONLexerBase3.next();
                jSONLexerBase3.matchStat = 3;
                jSONLexerBase3.token = 16;
                return l2;
            }
            this.matchStat = -1;
            return l2;
        }
        this.matchStat = -1;
        return 0L;
    }

    public final void scanTrue() {
        if (this.ch == 't') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'r') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'u') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'e') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        char c3 = jSONLexerBase4.ch;
                        if (c3 != ' ' && c3 != ',' && c3 != '}' && c3 != ']' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\u001a' && c3 != '\f' && c3 != '\b') {
                            throw new JSONException("scan true error");
                        }
                        this.token = 6;
                        return;
                    }
                    throw new JSONException("error parse true");
                }
                throw new JSONException("error parse true");
            }
            throw new JSONException("error parse true");
        }
        throw new JSONException("error parse true");
    }

    public final void scanTreeSet() {
        if (this.ch == 'T') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'r') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'e') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'e') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        if (jSONLexerBase4.ch == 'S') {
                            JSONLexerBase jSONLexerBase5 = this;
                            jSONLexerBase5.next();
                            if (jSONLexerBase5.ch == 'e') {
                                JSONLexerBase jSONLexerBase6 = this;
                                jSONLexerBase6.next();
                                if (jSONLexerBase6.ch == 't') {
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.next();
                                    char c3 = jSONLexerBase7.ch;
                                    if (c3 != ' ' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\f' && c3 != '\b' && c3 != '[' && c3 != '(') {
                                        throw new JSONException("scan set error");
                                    }
                                    this.token = 22;
                                    return;
                                }
                                throw new JSONException("error parse true");
                            }
                            throw new JSONException("error parse true");
                        }
                        throw new JSONException("error parse true");
                    }
                    throw new JSONException("error parse true");
                }
                throw new JSONException("error parse true");
            }
            throw new JSONException("error parse true");
        }
        throw new JSONException("error parse true");
    }

    public final void scanNullOrNew() {
        if (this.ch == 'n') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            char c3 = jSONLexerBase.ch;
            if (c3 == 'u') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'l') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'l') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        c3 = jSONLexerBase4.ch;
                        if (c3 != ' ' && c3 != ',' && c3 != '}' && c3 != ']' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\u001a' && c3 != '\f' && c3 != '\b') {
                            throw new JSONException("scan true error");
                        }
                        this.token = 8;
                        return;
                    }
                    throw new JSONException("error parse true");
                }
                throw new JSONException("error parse true");
            }
            if (c3 == 'e') {
                JSONLexerBase jSONLexerBase5 = this;
                jSONLexerBase5.next();
                if (jSONLexerBase5.ch == 'w') {
                    JSONLexerBase jSONLexerBase6 = this;
                    jSONLexerBase6.next();
                    c3 = jSONLexerBase6.ch;
                    if (c3 != ' ' && c3 != ',' && c3 != '}' && c3 != ']' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\u001a' && c3 != '\f' && c3 != '\b') {
                        throw new JSONException("scan true error");
                    }
                    this.token = 9;
                    return;
                }
                throw new JSONException("error parse w");
            }
            throw new JSONException("error parse e");
        }
        throw new JSONException("error parse null or new");
    }

    public final void scanUndefined() {
        if (this.ch == 'u') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'n') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'd') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 'e') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        if (jSONLexerBase4.ch == 'f') {
                            JSONLexerBase jSONLexerBase5 = this;
                            jSONLexerBase5.next();
                            if (jSONLexerBase5.ch == 'i') {
                                JSONLexerBase jSONLexerBase6 = this;
                                jSONLexerBase6.next();
                                if (jSONLexerBase6.ch == 'n') {
                                    JSONLexerBase jSONLexerBase7 = this;
                                    jSONLexerBase7.next();
                                    if (jSONLexerBase7.ch == 'e') {
                                        JSONLexerBase jSONLexerBase8 = this;
                                        jSONLexerBase8.next();
                                        if (jSONLexerBase8.ch == 'd') {
                                            JSONLexerBase jSONLexerBase9 = this;
                                            jSONLexerBase9.next();
                                            char c3 = jSONLexerBase9.ch;
                                            if (c3 != ' ' && c3 != ',' && c3 != '}' && c3 != ']' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\u001a' && c3 != '\f' && c3 != '\b') {
                                                throw new JSONException("scan false error");
                                            }
                                            this.token = 23;
                                            return;
                                        }
                                        throw new JSONException("error parse false");
                                    }
                                    throw new JSONException("error parse false");
                                }
                                throw new JSONException("error parse false");
                            }
                            throw new JSONException("error parse false");
                        }
                        throw new JSONException("error parse false");
                    }
                    throw new JSONException("error parse false");
                }
                throw new JSONException("error parse false");
            }
            throw new JSONException("error parse false");
        }
        throw new JSONException("error parse false");
    }

    public final void scanFalse() {
        if (this.ch == 'f') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'a') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 'l') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    if (jSONLexerBase3.ch == 's') {
                        JSONLexerBase jSONLexerBase4 = this;
                        jSONLexerBase4.next();
                        if (jSONLexerBase4.ch == 'e') {
                            JSONLexerBase jSONLexerBase5 = this;
                            jSONLexerBase5.next();
                            char c3 = jSONLexerBase5.ch;
                            if (c3 != ' ' && c3 != ',' && c3 != '}' && c3 != ']' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\u001a' && c3 != '\f' && c3 != '\b') {
                                throw new JSONException("scan false error");
                            }
                            this.token = 7;
                            return;
                        }
                        throw new JSONException("error parse false");
                    }
                    throw new JSONException("error parse false");
                }
                throw new JSONException("error parse false");
            }
            throw new JSONException("error parse false");
        }
        throw new JSONException("error parse false");
    }

    public final void scanIdent() {
        JSONLexerBase jSONLexerBase;
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            jSONLexerBase = this;
            ++jSONLexerBase.sp;
            jSONLexerBase.next();
        } while (Character.isLetterOrDigit(jSONLexerBase.ch));
        JSONLexerBase jSONLexerBase2 = this;
        Integer n2 = jSONLexerBase2.getKeyword(jSONLexerBase2.stringVal());
        if (n2 != null) {
            this.token = n2;
            return;
        }
        this.token = 18;
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    @Override
    public final boolean isBlankInput() {
        char c3;
        int n2 = 0;
        while ((c3 = this.charAt(n2)) != '\u001a') {
            if (!JSONLexerBase.isWhitespace(c3)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public final void skipWhitespace() {
        while (true) {
            char c3 = this.ch;
            boolean[] blArray = whitespaceFlags;
            if (c3 >= whitespaceFlags.length || !blArray[c3]) break;
            this.next();
        }
    }

    public final void scanSet() {
        if (this.ch == 'S') {
            JSONLexerBase jSONLexerBase = this;
            jSONLexerBase.next();
            if (jSONLexerBase.ch == 'e') {
                JSONLexerBase jSONLexerBase2 = this;
                jSONLexerBase2.next();
                if (jSONLexerBase2.ch == 't') {
                    JSONLexerBase jSONLexerBase3 = this;
                    jSONLexerBase3.next();
                    char c3 = jSONLexerBase3.ch;
                    if (c3 != ' ' && c3 != '\n' && c3 != '\r' && c3 != '\t' && c3 != '\f' && c3 != '\b' && c3 != '[' && c3 != '(') {
                        throw new JSONException("scan set error");
                    }
                    this.token = 21;
                    return;
                }
                throw new JSONException("error parse true");
            }
            throw new JSONException("error parse true");
        }
        throw new JSONException("error parse true");
    }

    protected final void putChar(char c3) {
        char[] cArray = this.sbuf;
        if (this.sp == this.sbuf.length) {
            cArray = new char[cArray.length << 1];
            int n2 = cArray.length;
            System.arraycopy(cArray, 0, cArray, 0, n2);
            this.sbuf = cArray;
        }
        int n3 = this.sp;
        this.sp = n3 + 1;
        this.sbuf[n3] = c3;
    }

    @Override
    public final void scanNumber() {
        char c3;
        block12: {
            block16: {
                char c4;
                block17: {
                    block15: {
                        block14: {
                            block13: {
                                block11: {
                                    JSONLexerBase jSONLexerBase = this;
                                    jSONLexerBase.np = jSONLexerBase.bp;
                                    if (jSONLexerBase.ch == '-') {
                                        JSONLexerBase jSONLexerBase2 = this;
                                        ++jSONLexerBase2.sp;
                                        jSONLexerBase2.next();
                                    }
                                    while ((c3 = this.ch) >= '0' && c3 <= '9') {
                                        JSONLexerBase jSONLexerBase3 = this;
                                        ++jSONLexerBase3.sp;
                                        jSONLexerBase3.next();
                                    }
                                    c3 = '\u0000';
                                    if (this.ch == '.') {
                                        JSONLexerBase jSONLexerBase4 = this;
                                        ++jSONLexerBase4.sp;
                                        jSONLexerBase4.next();
                                        c3 = '\u0001';
                                        while ((c4 = this.ch) >= '0' && c4 <= '9') {
                                            JSONLexerBase jSONLexerBase5 = this;
                                            ++jSONLexerBase5.sp;
                                            jSONLexerBase5.next();
                                        }
                                    }
                                    if ((c4 = this.ch) != 'L') break block11;
                                    JSONLexerBase jSONLexerBase6 = this;
                                    ++jSONLexerBase6.sp;
                                    jSONLexerBase6.next();
                                    break block12;
                                }
                                if (c4 != 'S') break block13;
                                JSONLexerBase jSONLexerBase = this;
                                ++jSONLexerBase.sp;
                                jSONLexerBase.next();
                                break block12;
                            }
                            if (c4 != 'B') break block14;
                            JSONLexerBase jSONLexerBase = this;
                            ++jSONLexerBase.sp;
                            jSONLexerBase.next();
                            break block12;
                        }
                        if (c4 != 'F') break block15;
                        JSONLexerBase jSONLexerBase = this;
                        ++jSONLexerBase.sp;
                        jSONLexerBase.next();
                        break block16;
                    }
                    if (c4 != 'D') break block17;
                    JSONLexerBase jSONLexerBase = this;
                    ++jSONLexerBase.sp;
                    jSONLexerBase.next();
                    break block16;
                }
                if (c4 != 'e' && c4 != 'E') break block12;
                JSONLexerBase jSONLexerBase = this;
                ++jSONLexerBase.sp;
                jSONLexerBase.next();
                c3 = jSONLexerBase.ch;
                if (c3 == '+' || c3 == '-') {
                    JSONLexerBase jSONLexerBase7 = this;
                    ++jSONLexerBase7.sp;
                    jSONLexerBase7.next();
                }
                while ((c3 = this.ch) >= '0' && c3 <= '9') {
                    JSONLexerBase jSONLexerBase8 = this;
                    ++jSONLexerBase8.sp;
                    jSONLexerBase8.next();
                }
                c3 = this.ch;
                if (c3 == 'D' || c3 == 'F') {
                    JSONLexerBase jSONLexerBase9 = this;
                    ++jSONLexerBase9.sp;
                    jSONLexerBase9.next();
                }
            }
            c3 = '\u0001';
        }
        if (c3 != '\u0000') {
            this.token = 3;
            return;
        }
        this.token = 2;
    }

    @Override
    public final long longValue() {
        int n2;
        boolean bl;
        long l2;
        block9: {
            long l3;
            JSONLexerBase jSONLexerBase = this;
            l2 = 0L;
            bl = false;
            int n3 = jSONLexerBase.np;
            int n4 = n3 + this.sp;
            if (jSONLexerBase.charAt(n3) == '-') {
                bl = true;
                l3 = Long.MIN_VALUE;
                ++n3;
            } else {
                l3 = -9223372036854775807L;
            }
            if (n3 < n4) {
                l2 = -digits[this.charAt(n3++)];
            }
            while (n3 < n4) {
                n2 = n3 + 1;
                char c3 = this.charAt(n3);
                n3 = c3;
                if (c3 != 'L' && n3 != 83 && n3 != 66) {
                    n3 = digits[n3];
                    if (l2 >= -922337203685477580L) {
                        long l4 = n3;
                        if ((l2 *= 10L) >= l3 + l4) {
                            l2 -= l4;
                            n3 = n2;
                            continue;
                        }
                        throw new NumberFormatException(this.numberString());
                    }
                    throw new NumberFormatException(this.numberString());
                }
                break block9;
            }
            n2 = n3;
        }
        if (bl) {
            if (n2 > this.np + 1) {
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l2;
    }

    @Override
    public final Number decimalValue(boolean bl) {
        JSONLexerBase jSONLexerBase = this;
        char c3 = jSONLexerBase.charAt(jSONLexerBase.np + this.sp - 1);
        if (c3 == 'F') {
            return Float.valueOf(Float.parseFloat(this.numberString()));
        }
        if (c3 == 'D') {
            return Double.parseDouble(this.numberString());
        }
        if (bl) {
            return this.decimalValue();
        }
        return this.doubleValue();
    }

    @Override
    public final BigDecimal decimalValue() {
        return new BigDecimal(this.numberString());
    }

    public Integer getKeyword(String string) {
        return this.keywods.get(string);
    }
}

