/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.parser;

import com.qx.wz.external.fastjson.JSON;
import com.qx.wz.external.fastjson.JSONException;
import com.qx.wz.external.fastjson.parser.JSONLexerBase;
import com.qx.wz.external.fastjson.parser.SymbolTable;
import com.qx.wz.external.fastjson.util.Base64;
import com.qx.wz.external.fastjson.util.IOUtils;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;

public final class JSONReaderScanner
extends JSONLexerBase {
    public static int BUF_INIT_LEN = 8192;
    private static final ThreadLocal<SoftReference<char[]>> BUF_REF_LOCAL = new ThreadLocal();
    private Reader reader;
    private char[] buf;
    private int bufLength;

    public JSONReaderScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(String string, int n2) {
        StringReader stringReader;
        JSONReaderScanner jSONReaderScanner = closeable;
        Closeable closeable = stringReader;
        stringReader = new StringReader(string);
        jSONReaderScanner((Reader)closeable, n2);
    }

    public JSONReaderScanner(char[] cArray, int n2) {
        int n3 = JSON.DEFAULT_PARSER_FEATURE;
        this(cArray, n2, n3);
    }

    public JSONReaderScanner(Reader reader) {
        this(reader, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader, int n2) {
        JSONReaderScanner jSONReaderScanner;
        this.reader = reader;
        this.features = n2;
        SoftReference<char[]> softReference = BUF_REF_LOCAL.get();
        if (softReference != null) {
            this.buf = softReference.get();
            BUF_REF_LOCAL.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[BUF_INIT_LEN];
        }
        try {
            JSONReaderScanner jSONReaderScanner2 = this;
            jSONReaderScanner = jSONReaderScanner2;
            jSONReaderScanner2.bufLength = reader.read(this.buf);
            jSONReaderScanner2.bp = -1;
            jSONReaderScanner2.next();
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        if (jSONReaderScanner.ch == '\ufeff') {
            this.next();
        }
    }

    public JSONReaderScanner(char[] cArray, int n2, int n3) {
        CharArrayReader charArrayReader;
        JSONReaderScanner jSONReaderScanner = closeable;
        Closeable closeable = charArrayReader;
        charArrayReader = new CharArrayReader(cArray, 0, n2);
        jSONReaderScanner((Reader)closeable, n3);
    }

    @Override
    public final char charAt(int n2) {
        int n3;
        block10: {
            block9: {
                block8: {
                    int n4;
                    int n5;
                    char[] cArray;
                    Reader reader;
                    n3 = this.bufLength;
                    if (n2 < n3) break block9;
                    if (n3 == -1) {
                        if (n2 < this.sp) {
                            return this.buf[n2];
                        }
                        return '\u001a';
                    }
                    int n6 = n3 - (n3 = this.bp);
                    if (n6 > 0) {
                        System.arraycopy(this.buf, n3, this.buf, 0, n6);
                    }
                    try {
                        reader = this.reader;
                        cArray = this.buf;
                        n5 = n6;
                        n4 = this.buf.length;
                    }
                    catch (IOException iOException) {
                        throw new JSONException(iOException.getMessage(), iOException);
                    }
                    n3 = reader.read(cArray, n5, n4 - n6);
                    this.bufLength = n3;
                    if (n3 == 0) break block8;
                    if (n3 == -1) {
                        return '\u001a';
                    }
                    int n7 = n2;
                    this.bufLength = n3 + n6;
                    n2 = this.bp;
                    n3 = n7 - n2;
                    this.np -= n2;
                    this.bp = 0;
                    break block10;
                }
                throw new JSONException("illegal stat, textLength is zero");
            }
            n3 = n2;
        }
        return this.buf[n3];
    }

    @Override
    public final int indexOf(char c3, int n2) {
        n2 -= this.bp;
        while (true) {
            JSONReaderScanner jSONReaderScanner = this;
            if (c3 == jSONReaderScanner.charAt(jSONReaderScanner.bp + n2)) {
                return n2 + this.bp;
            }
            if (c3 == '\u001a') {
                return -1;
            }
            ++n2;
        }
    }

    @Override
    public final String addSymbol(int n2, int n3, int n4, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.buf, n2, n3, n4);
    }

    @Override
    public final char next() {
        int n2;
        block16: {
            this.bp = n2 = this.bp + 1;
            int n3 = this.bufLength;
            if (n2 >= n3) {
                block14: {
                    block15: {
                        block13: {
                            if (n3 == -1) {
                                return '\u001a';
                            }
                            n2 = this.sp;
                            if (n2 > 0) {
                                n2 = n3 - n2;
                                if (this.ch == '\"') {
                                    --n2;
                                }
                                n3 = this.sp;
                                System.arraycopy(this.buf, n2, this.buf, 0, n3);
                            }
                            JSONReaderScanner jSONReaderScanner = this;
                            jSONReaderScanner.np = -1;
                            jSONReaderScanner.bp = n2 = jSONReaderScanner.sp;
                            try {
                                n3 = jSONReaderScanner.buf.length - n2;
                                if (n3 != 0) break block13;
                            }
                            catch (IOException iOException) {
                                throw new JSONException(iOException.getMessage(), iOException);
                            }
                            JSONReaderScanner jSONReaderScanner2 = this;
                            JSONReaderScanner jSONReaderScanner3 = jSONReaderScanner2;
                            int n4 = jSONReaderScanner2.buf.length;
                            char[] cArray = new char[n4 << 1];
                            char[] cArray2 = this.buf;
                            int n5 = 0;
                            System.arraycopy(cArray2, 0, cArray, n5, this.buf.length);
                            jSONReaderScanner3.buf = cArray;
                            n3 = cArray.length - n2;
                        }
                        Reader reader = this.reader;
                        JSONReaderScanner jSONReaderScanner = this;
                        JSONReaderScanner jSONReaderScanner4 = jSONReaderScanner;
                        char[] cArray = jSONReaderScanner.buf;
                        n3 = reader.read(cArray, jSONReaderScanner4.bp, n3);
                        this.bufLength = n3;
                        if (n3 == 0) break block14;
                        if (n3 != -1) break block15;
                        this.ch = (char)26;
                        return '\u001a';
                    }
                    this.bufLength = n3 + this.bp;
                    break block16;
                }
                throw new JSONException("illegal stat, textLength is zero");
            }
        }
        this.ch = this.buf[n2];
        return this.ch;
    }

    @Override
    protected final void copyTo(int n2, int n3, char[] cArray) {
        System.arraycopy(this.buf, n2, cArray, 0, n3);
    }

    @Override
    public final byte[] bytesValue() {
        JSONReaderScanner jSONReaderScanner = this;
        int n2 = jSONReaderScanner.np + 1;
        return Base64.decodeFast(this.buf, n2, jSONReaderScanner.sp);
    }

    @Override
    protected final void arrayCopy(int n2, char[] cArray, int n3, int n4) {
        System.arraycopy(this.buf, n2, cArray, n3, n4);
    }

    @Override
    public final String stringVal() {
        Object object;
        if (!((JSONLexerBase)object).hasSpecial) {
            int n2 = ((JSONLexerBase)object).np + 1;
            if (n2 >= 0) {
                if (n2 <= ((JSONReaderScanner)object).buf.length - ((JSONLexerBase)object).sp) {
                    Object object2 = object;
                    object = ((JSONReaderScanner)object2).buf;
                    int n3 = ((JSONLexerBase)object2).sp;
                    return new String((char[])object, n2, n3);
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        JSONReaderScanner jSONReaderScanner = object;
        object = jSONReaderScanner.sbuf;
        int n4 = jSONReaderScanner.sp;
        return new String((char[])object, 0, n4);
    }

    @Override
    public final String subString(int n2, int n3) {
        if (n3 >= 0) {
            return new String(this.buf, n2, n3);
        }
        throw new StringIndexOutOfBoundsException(n3);
    }

    @Override
    public final String numberString() {
        int n2 = this.np;
        if (n2 == -1) {
            n2 = 0;
        }
        char c3 = this.charAt(n2 + this.sp - 1);
        int n3 = this.sp;
        if (c3 == 'L' || c3 == 'S' || c3 == 'B' || c3 == 'F' || c3 == 'D') {
            --n3;
        }
        return new String(this.buf, n2, n3);
    }

    @Override
    public final void close() {
        JSONReaderScanner jSONReaderScanner = this;
        super.close();
        BUF_REF_LOCAL.set(new SoftReference<char[]>(this.buf));
        jSONReaderScanner.buf = null;
        IOUtils.close(jSONReaderScanner.reader);
    }

    @Override
    public final boolean isEOF() {
        if (this.bufLength != -1) {
            int n2 = this.bp;
            char[] cArray = this.buf;
            if (n2 != this.buf.length && (this.ch != '\u001a' || n2 + 1 != cArray.length)) {
                return false;
            }
        }
        return true;
    }
}

