/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.parser;

import com.qx.wz.external.fastjson.JSONArray;
import com.qx.wz.external.fastjson.JSONObject;
import com.qx.wz.external.fastjson.annotation.JSONType;
import com.qx.wz.external.fastjson.parser.SymbolTable;
import com.qx.wz.external.fastjson.parser.deserializer.ArrayDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.BooleanFieldDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.CharArrayDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.ClassDerializer;
import com.qx.wz.external.fastjson.parser.deserializer.CollectionDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.DateDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.DateFormatDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.EnumDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.FieldDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.IntegerFieldDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.JSONArrayDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.JSONObjectDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.JavaObjectDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.LongFieldDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.MapDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.NumberDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.ObjectDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.SqlDateDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.StackTraceElementDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.StringFieldDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.ThrowableDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.TimeDeserializer;
import com.qx.wz.external.fastjson.parser.deserializer.TimestampDeserializer;
import com.qx.wz.external.fastjson.serializer.BigDecimalCodec;
import com.qx.wz.external.fastjson.serializer.BigIntegerCodec;
import com.qx.wz.external.fastjson.serializer.BooleanCodec;
import com.qx.wz.external.fastjson.serializer.CalendarCodec;
import com.qx.wz.external.fastjson.serializer.CharacterCodec;
import com.qx.wz.external.fastjson.serializer.CharsetCodec;
import com.qx.wz.external.fastjson.serializer.CurrencyCodec;
import com.qx.wz.external.fastjson.serializer.FloatCodec;
import com.qx.wz.external.fastjson.serializer.InetAddressCodec;
import com.qx.wz.external.fastjson.serializer.InetSocketAddressCodec;
import com.qx.wz.external.fastjson.serializer.IntegerCodec;
import com.qx.wz.external.fastjson.serializer.LocaleCodec;
import com.qx.wz.external.fastjson.serializer.LongCodec;
import com.qx.wz.external.fastjson.serializer.PatternCodec;
import com.qx.wz.external.fastjson.serializer.StringCodec;
import com.qx.wz.external.fastjson.serializer.TimeZoneCodec;
import com.qx.wz.external.fastjson.serializer.URICodec;
import com.qx.wz.external.fastjson.serializer.URLCodec;
import com.qx.wz.external.fastjson.serializer.UUIDCodec;
import com.qx.wz.external.fastjson.util.FieldInfo;
import com.qx.wz.external.fastjson.util.IdentityHashMap;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class ParserConfig {
    private static ParserConfig global = new ParserConfig();
    private final Set<Class<?>> primitiveClasses;
    private final IdentityHashMap<Type, ObjectDeserializer> derializers;
    protected final SymbolTable symbolTable;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        ParserConfig parserConfig = this;
        parserConfig.primitiveClasses = new HashSet();
        parserConfig.derializers = new IdentityHashMap();
        parserConfig.symbolTable = new SymbolTable();
        parserConfig.primitiveClasses.add(Boolean.TYPE);
        parserConfig.primitiveClasses.add(Boolean.class);
        parserConfig.primitiveClasses.add(Character.TYPE);
        parserConfig.primitiveClasses.add(Character.class);
        parserConfig.primitiveClasses.add(Byte.TYPE);
        parserConfig.primitiveClasses.add(Byte.class);
        parserConfig.primitiveClasses.add(Short.TYPE);
        parserConfig.primitiveClasses.add(Short.class);
        parserConfig.primitiveClasses.add(Integer.TYPE);
        parserConfig.primitiveClasses.add(Integer.class);
        parserConfig.primitiveClasses.add(Long.TYPE);
        parserConfig.primitiveClasses.add(Long.class);
        parserConfig.primitiveClasses.add(Float.TYPE);
        parserConfig.primitiveClasses.add(Float.class);
        parserConfig.primitiveClasses.add(Double.TYPE);
        parserConfig.primitiveClasses.add(Double.class);
        parserConfig.primitiveClasses.add(BigInteger.class);
        parserConfig.primitiveClasses.add(BigDecimal.class);
        parserConfig.primitiveClasses.add(String.class);
        parserConfig.primitiveClasses.add(Date.class);
        parserConfig.primitiveClasses.add(java.sql.Date.class);
        parserConfig.primitiveClasses.add(Time.class);
        parserConfig.primitiveClasses.add(Timestamp.class);
        parserConfig.derializers.put((Type)((Object)SimpleDateFormat.class), DateFormatDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Timestamp.class), TimestampDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Time.class), TimeDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Date.class), DateDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Calendar.class), CalendarCodec.instance);
        parserConfig.derializers.put((Type)((Object)JSONObject.class), JSONObjectDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)JSONArray.class), JSONArrayDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Collection.class), CollectionDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)List.class), CollectionDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)ArrayList.class), CollectionDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)String.class), StringCodec.instance);
        parserConfig.derializers.put(Character.TYPE, CharacterCodec.instance);
        parserConfig.derializers.put((Type)((Object)Character.class), CharacterCodec.instance);
        parserConfig.derializers.put(Byte.TYPE, NumberDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Byte.class), NumberDeserializer.instance);
        parserConfig.derializers.put(Short.TYPE, NumberDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Short.class), NumberDeserializer.instance);
        parserConfig.derializers.put(Integer.TYPE, IntegerCodec.instance);
        parserConfig.derializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        parserConfig.derializers.put(Long.TYPE, LongCodec.instance);
        parserConfig.derializers.put((Type)((Object)Long.class), LongCodec.instance);
        parserConfig.derializers.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        parserConfig.derializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        parserConfig.derializers.put(Float.TYPE, FloatCodec.instance);
        parserConfig.derializers.put((Type)((Object)Float.class), FloatCodec.instance);
        parserConfig.derializers.put(Double.TYPE, NumberDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Double.class), NumberDeserializer.instance);
        parserConfig.derializers.put(Boolean.TYPE, BooleanCodec.instance);
        parserConfig.derializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        parserConfig.derializers.put((Type)((Object)Class.class), ClassDerializer.instance);
        parserConfig.derializers.put((Type)((Object)char[].class), CharArrayDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)UUID.class), UUIDCodec.instance);
        parserConfig.derializers.put((Type)((Object)TimeZone.class), TimeZoneCodec.instance);
        parserConfig.derializers.put((Type)((Object)Locale.class), LocaleCodec.instance);
        parserConfig.derializers.put((Type)((Object)Currency.class), CurrencyCodec.instance);
        parserConfig.derializers.put((Type)((Object)InetAddress.class), InetAddressCodec.instance);
        parserConfig.derializers.put((Type)((Object)Inet4Address.class), InetAddressCodec.instance);
        parserConfig.derializers.put((Type)((Object)Inet6Address.class), InetAddressCodec.instance);
        parserConfig.derializers.put((Type)((Object)InetSocketAddress.class), InetSocketAddressCodec.instance);
        parserConfig.derializers.put((Type)((Object)URI.class), URICodec.instance);
        parserConfig.derializers.put((Type)((Object)URL.class), URLCodec.instance);
        parserConfig.derializers.put((Type)((Object)Pattern.class), PatternCodec.instance);
        parserConfig.derializers.put((Type)((Object)Charset.class), CharsetCodec.instance);
        parserConfig.derializers.put((Type)((Object)Number.class), NumberDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)StackTraceElement.class), StackTraceElementDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        parserConfig.derializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
    }

    public static Field getField(Class<?> clazz, String string) {
        Field field = ParserConfig.getField0(clazz, string);
        if (field == null) {
            field = ParserConfig.getField0(clazz, "_" + string);
        }
        if (field == null) {
            field = ParserConfig.getField0(clazz, "m_" + string);
        }
        return field;
    }

    private static Field getField0(Class<?> clazz, String string) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!string.equals(field.getName())) continue;
            return field;
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            return ParserConfig.getField(clazz.getSuperclass(), string);
        }
        return null;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDerializers() {
        return this.derializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        Object object = this.derializers.get(type);
        if (object != null) {
            return object;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            object = ((ParameterizedType)type).getRawType();
            if (object instanceof Class) {
                return this.getDeserializer((Class)object, type);
            }
            return this.getDeserializer((Type)object);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type clazz2) {
        ObjectDeserializer objectDeserializer = this.derializers.get(clazz2);
        if (objectDeserializer != null) {
            return objectDeserializer;
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        if ((objectDeserializer = this.derializers.get(clazz2)) != null) {
            return objectDeserializer;
        }
        Object object = clazz.getAnnotation(JSONType.class);
        if (object != null && (object = object.mappingTo()) != Void.class) {
            Object object2 = object;
            return this.getDeserializer((Class<?>)object2, (Type)object2);
        }
        if (clazz2 instanceof WildcardType || clazz2 instanceof TypeVariable || clazz2 instanceof ParameterizedType) {
            objectDeserializer = this.derializers.get(clazz);
        }
        if (objectDeserializer != null) {
            return objectDeserializer;
        }
        objectDeserializer = this.derializers.get(clazz2);
        if (objectDeserializer != null) {
            return objectDeserializer;
        }
        if (clazz.isEnum()) {
            EnumDeserializer enumDeserializer;
            objectDeserializer = enumDeserializer;
            enumDeserializer = new EnumDeserializer(clazz);
        } else if (clazz.isArray()) {
            objectDeserializer = ArrayDeserializer.instance;
        } else if (clazz != Set.class && clazz != HashSet.class && clazz != Collection.class && clazz != List.class && clazz != ArrayList.class) {
            if (Collection.class.isAssignableFrom(clazz)) {
                objectDeserializer = CollectionDeserializer.instance;
            } else if (Map.class.isAssignableFrom(clazz)) {
                objectDeserializer = MapDeserializer.instance;
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                ThrowableDeserializer throwableDeserializer;
                objectDeserializer = throwableDeserializer;
                throwableDeserializer = new ThrowableDeserializer(this, clazz);
            } else {
                objectDeserializer = this.createJavaBeanDeserializer(clazz, clazz2);
            }
        } else {
            objectDeserializer = CollectionDeserializer.instance;
        }
        this.putDeserializer(clazz2, objectDeserializer);
        return objectDeserializer;
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        return new JavaBeanDeserializer(this, clazz, type);
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig parserConfig, Class<?> clazz, FieldInfo fieldInfo) {
        Class<?> clazz2 = fieldInfo.getFieldClass();
        if (clazz2 != Boolean.TYPE && clazz2 != Boolean.class) {
            if (clazz2 != Integer.TYPE && clazz2 != Integer.class) {
                if (clazz2 != Long.TYPE && clazz2 != Long.class) {
                    if (clazz2 == String.class) {
                        return new StringFieldDeserializer(parserConfig, clazz, fieldInfo);
                    }
                    if (clazz2 != List.class && clazz2 != ArrayList.class) {
                        return new DefaultFieldDeserializer(parserConfig, clazz, fieldInfo);
                    }
                    return new ArrayListTypeFieldDeserializer(parserConfig, clazz, fieldInfo);
                }
                return new LongFieldDeserializer(parserConfig, clazz, fieldInfo);
            }
            return new IntegerFieldDeserializer(parserConfig, clazz, fieldInfo);
        }
        return new BooleanFieldDeserializer(parserConfig, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer objectDeserializer) {
        this.derializers.put(type, objectDeserializer);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        ParserConfig parserConfig = clazz;
        FieldInfo fieldInfo2 = fieldInfo;
        Class<?> clazz = fieldInfo2.getFieldClass();
        return parserConfig.getDeserializer(clazz, fieldInfo2.getFieldType());
    }

    public boolean isPrimitive(Class<?> clazz) {
        return this.primitiveClasses.contains(clazz);
    }

    public Map<String, FieldDeserializer> getFieldDeserializers(Class<?> clazz) {
        if ((this = ((ParserConfig)this).getDeserializer(clazz)) instanceof JavaBeanDeserializer) {
            return ((JavaBeanDeserializer)this).getFieldDeserializerMap();
        }
        return Collections.emptyMap();
    }
}

