/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.parser.DefaultJSONParser;
import com.qx.wz.external.fastjson.parser.JSONLexer;
import com.qx.wz.external.fastjson.parser.deserializer.ObjectDeserializer;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class BigDecimalCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    public static <T> T deserialze(DefaultJSONParser object) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).getLexer();
        if (jSONLexer.token() == 2) {
            JSONLexer jSONLexer2 = jSONLexer;
            long l2 = jSONLexer2.longValue();
            jSONLexer2.nextToken(16);
            return (T)new BigDecimal(l2);
        }
        if (jSONLexer.token() == 3) {
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        if ((object = ((DefaultJSONParser)object).parse()) == null) {
            return null;
        }
        return (T)TypeUtils.castToBigDecimal(object);
    }

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type) {
        SerializeWriter serializeWriter = ((JSONSerializer)object).getWriter();
        if (object2 == null) {
            if (serializeWriter.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                serializeWriter.write('0');
                return;
            }
            serializeWriter.writeNull();
            return;
        }
        SerializeWriter serializeWriter2 = serializeWriter;
        object = (BigDecimal)object2;
        serializeWriter2.write(((BigDecimal)object).toString());
        if (serializeWriter2.isEnabled(SerializerFeature.WriteClassName) && type != BigDecimal.class && ((BigDecimal)object).scale() == 0) {
            serializeWriter.write('.');
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return BigDecimalCodec.deserialze(defaultJSONParser);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

