/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.parser.DefaultJSONParser;
import com.qx.wz.external.fastjson.parser.deserializer.ObjectDeserializer;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.lang.reflect.Type;

public class BooleanCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final BooleanCodec instance = new BooleanCodec();

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type) {
        SerializeWriter serializeWriter = ((JSONSerializer)object).getWriter();
        object = (Boolean)object2;
        if (object == null) {
            if (serializeWriter.isEnabled(SerializerFeature.WriteNullBooleanAsFalse)) {
                serializeWriter.write("false");
                return;
            }
            serializeWriter.writeNull();
            return;
        }
        if (((Boolean)object).booleanValue()) {
            serializeWriter.write("true");
            return;
        }
        serializeWriter.write("false");
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Boolean bl;
        Object object2 = defaultJSONParser.getLexer();
        if (object2.token() == 6) {
            object2.nextToken(16);
            bl = Boolean.TRUE;
        } else if (object2.token() == 7) {
            object2.nextToken(16);
            bl = Boolean.FALSE;
        } else if (object2.token() == 2) {
            int n2 = object2.intValue();
            object2.nextToken(16);
            bl = n2 == 1 ? Boolean.TRUE : Boolean.FALSE;
        } else {
            object2 = defaultJSONParser.parse();
            if (object2 == null) {
                return null;
            }
            bl = TypeUtils.castToBoolean(object2);
        }
        return (T)bl;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

