/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.JSON;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.IOUtils;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateSerializer
implements ObjectSerializer {
    public static final DateSerializer instance = new DateSerializer();

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type) {
        SerializeWriter serializeWriter = ((JSONSerializer)object).getWriter();
        if (object2 == null) {
            serializeWriter.writeNull();
            return;
        }
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && object2.getClass() != type) {
            if (object2.getClass() == Date.class) {
                serializeWriter.write("new Date(");
                serializeWriter.writeLongAndChar(((Date)object2).getTime(), ')');
                return;
            }
            SerializeWriter serializeWriter2 = serializeWriter;
            SerializeWriter serializeWriter3 = serializeWriter;
            serializeWriter3.write('{');
            serializeWriter3.writeFieldName(JSON.DEFAULT_TYPE_KEY);
            ((JSONSerializer)object).write(object2.getClass().getName());
            long l2 = ((Date)object2).getTime();
            serializeWriter2.writeFieldValue(',', "val", l2);
            serializeWriter2.write('}');
            return;
        }
        object2 = (Date)object2;
        if (serializeWriter.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            if ((object = ((JSONSerializer)object).getDateFormat()) == null) {
                SimpleDateFormat simpleDateFormat;
                object = simpleDateFormat;
                simpleDateFormat = new SimpleDateFormat(JSON.DEFFAULT_DATE_FORMAT);
            }
            serializeWriter.writeString(((DateFormat)object).format((Date)object2));
            return;
        }
        long l3 = ((Date)object2).getTime();
        if (((JSONSerializer)object).isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] cArray;
            if (((JSONSerializer)object).isEnabled(SerializerFeature.UseSingleQuotes)) {
                serializeWriter.append('\'');
            } else {
                serializeWriter.append('\"');
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l3);
            int n2 = calendar.get(1);
            int n3 = calendar.get(2) + 1;
            int n4 = calendar.get(5);
            int n5 = calendar.get(11);
            int n6 = calendar.get(12);
            int n7 = calendar.get(13);
            int n8 = calendar.get(14);
            if (n8 != 0) {
                cArray = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(n8, 23, cArray);
                IOUtils.getChars(n7, 19, cArray);
                IOUtils.getChars(n6, 16, cArray);
                IOUtils.getChars(n5, 13, cArray);
                IOUtils.getChars(n4, 10, cArray);
                IOUtils.getChars(n3, 7, cArray);
                IOUtils.getChars(n2, 4, cArray);
            } else if (n7 == 0 && n6 == 0 && n5 == 0) {
                cArray = "0000-00-00".toCharArray();
                IOUtils.getChars(n4, 10, cArray);
                IOUtils.getChars(n3, 7, cArray);
                IOUtils.getChars(n2, 4, cArray);
            } else {
                cArray = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(n7, 19, cArray);
                IOUtils.getChars(n6, 16, cArray);
                IOUtils.getChars(n5, 13, cArray);
                IOUtils.getChars(n4, 10, cArray);
                IOUtils.getChars(n3, 7, cArray);
                IOUtils.getChars(n2, 4, cArray);
            }
            serializeWriter.write(cArray);
            if (((JSONSerializer)object).isEnabled(SerializerFeature.UseSingleQuotes)) {
                serializeWriter.append('\'');
                return;
            }
            serializeWriter.append('\"');
            return;
        }
        serializeWriter.writeLong(l3);
    }
}

