/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;

public class DoubleArraySerializer
implements ObjectSerializer {
    public static final DoubleArraySerializer instance = new DoubleArraySerializer();

    @Override
    public final void write(JSONSerializer object, Object object2, Object object3, Type type) {
        SerializeWriter serializeWriter = ((JSONSerializer)object).getWriter();
        if (object2 == null) {
            if (serializeWriter.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                serializeWriter.write("[]");
                return;
            }
            serializeWriter.writeNull();
            return;
        }
        double[] dArray = (double[])object2;
        object = dArray;
        int n2 = dArray.length - 1;
        if (n2 == -1) {
            serializeWriter.append("[]");
            return;
        }
        serializeWriter.append('[');
        for (int i3 = 0; i3 < n2; ++i3) {
            Object object4 = object[i3];
            if (Double.isNaN((double)object4)) {
                serializeWriter.writeNull();
            } else {
                serializeWriter.append(Double.toString((double)object4));
            }
            serializeWriter.append(',');
        }
        Object object5 = object[n2];
        if (Double.isNaN((double)object5)) {
            serializeWriter.writeNull();
        } else {
            serializeWriter.append(Double.toString((double)object5));
        }
        serializeWriter.append(']');
    }
}

