/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DoubleSerializer
implements ObjectSerializer {
    public static final DoubleSerializer instance = new DoubleSerializer();
    private DecimalFormat decimalFormat;

    public DoubleSerializer() {
        this.decimalFormat = null;
    }

    public DoubleSerializer(DecimalFormat decimalFormat) {
        this.decimalFormat = null;
        this.decimalFormat = decimalFormat;
    }

    public DoubleSerializer(String string) {
        DecimalFormat decimalFormat;
        DoubleSerializer doubleSerializer = decimalFormat2;
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat(string);
        doubleSerializer(decimalFormat2);
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type) {
        object2 = jSONSerializer.getWriter();
        if (object == null) {
            if (jSONSerializer.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                ((SerializeWriter)object2).write('0');
                return;
            }
            ((SerializeWriter)object2).writeNull();
            return;
        }
        double d3 = (Double)object;
        if (Double.isNaN(d3)) {
            ((SerializeWriter)object2).writeNull();
            return;
        }
        if (Double.isInfinite(d3)) {
            ((SerializeWriter)object2).writeNull();
            return;
        }
        Object object3 = ((DoubleSerializer)object3).decimalFormat;
        if (object3 == null) {
            object3 = Double.toString(d3);
            if (((String)object3).endsWith(".0")) {
                Object object4 = object3;
                object3 = ((String)object4).substring(0, ((String)object4).length() - 2);
            }
        } else {
            object3 = ((NumberFormat)object3).format(d3);
        }
        ((SerializeWriter)object2).append((CharSequence)object3);
        if (jSONSerializer.isEnabled(SerializerFeature.WriteClassName)) {
            ((SerializeWriter)object2).write('D');
        }
    }
}

