/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.parser.DefaultJSONParser;
import com.qx.wz.external.fastjson.parser.deserializer.ObjectDeserializer;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializeWriter;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class IntegerCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static IntegerCodec instance = new IntegerCodec();

    @Override
    public void write(JSONSerializer clazz, Object object, Object object2, Type type) {
        SerializeWriter serializeWriter = ((JSONSerializer)((Object)clazz)).getWriter();
        if ((object = (Number)object) == null) {
            if (serializeWriter.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                serializeWriter.write('0');
                return;
            }
            serializeWriter.writeNull();
            return;
        }
        serializeWriter.writeInt(((Number)object).intValue());
        if (((JSONSerializer)((Object)clazz)).isEnabled(SerializerFeature.WriteClassName)) {
            clazz = object.getClass();
            if (clazz == Byte.class) {
                serializeWriter.write('B');
                return;
            }
            if (clazz == Short.class) {
                serializeWriter.write('S');
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Integer n2;
        Object object2 = defaultJSONParser.getLexer();
        if (object2.token() == 8) {
            object2.nextToken(16);
            return null;
        }
        if (object2.token() == 2) {
            int n3 = object2.intValue();
            object2.nextToken(16);
            n2 = n3;
        } else if (object2.token() == 3) {
            Object object3 = object2;
            object2 = object3.decimalValue();
            object3.nextToken(16);
            n2 = ((BigDecimal)object2).intValue();
        } else {
            n2 = TypeUtils.castToInt(defaultJSONParser.parse());
        }
        return (T)n2;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

