/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.annotation.JSONField;
import com.qx.wz.external.fastjson.serializer.FieldSerializer;
import com.qx.wz.external.fastjson.serializer.JSONSerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.SerializerFeature;
import com.qx.wz.external.fastjson.util.FieldInfo;
import java.lang.reflect.Type;
import java.util.Collection;

public class ObjectFieldSerializer
extends FieldSerializer {
    private String format;
    boolean writeNumberAsZero = false;
    boolean writeNullStringAsEmpty = false;
    boolean writeNullBooleanAsFalse = false;
    boolean writeNullListAsEmpty = false;
    boolean writeEnumUsingToString = false;
    private RuntimeSerializerInfo runtimeInfo;

    public ObjectFieldSerializer(FieldInfo serializerFeatureArray) {
        super((FieldInfo)serializerFeatureArray);
        serializerFeatureArray = serializerFeatureArray.getAnnotation(JSONField.class);
        if (serializerFeatureArray != null) {
            String string;
            this.format = string = serializerFeatureArray.format();
            if (string.trim().length() == 0) {
                this.format = null;
            }
            for (SerializerFeature serializerFeature : serializerFeatureArray.serialzeFeatures()) {
                if (serializerFeature == SerializerFeature.WriteNullNumberAsZero) {
                    this.writeNumberAsZero = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteNullStringAsEmpty) {
                    this.writeNullStringAsEmpty = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteNullBooleanAsFalse) {
                    this.writeNullBooleanAsFalse = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteNullListAsEmpty) {
                    this.writeNullListAsEmpty = true;
                    continue;
                }
                if (serializerFeature != SerializerFeature.WriteEnumUsingToString) continue;
                this.writeEnumUsingToString = true;
            }
        }
    }

    @Override
    public void writeProperty(JSONSerializer jSONSerializer, Object object) {
        ObjectFieldSerializer objectFieldSerializer = this;
        objectFieldSerializer.writePrefix(jSONSerializer);
        objectFieldSerializer.writeValue(jSONSerializer, object);
    }

    @Override
    public void writeValue(JSONSerializer object, Object object2) {
        Object object3;
        Class<?> clazz;
        Object object4 = ((ObjectFieldSerializer)object3).format;
        if (object4 != null) {
            ((JSONSerializer)object).writeWithFormat(object2, (String)object4);
            return;
        }
        if (((ObjectFieldSerializer)object3).runtimeInfo == null) {
            RuntimeSerializerInfo runtimeSerializerInfo;
            object4 = object2 == null ? ((FieldSerializer)object3).fieldInfo.getFieldClass() : object2.getClass();
            clazz = ((JSONSerializer)object).getObjectWriter((Class<?>)object4);
            RuntimeSerializerInfo runtimeSerializerInfo2 = runtimeSerializerInfo;
            runtimeSerializerInfo = new RuntimeSerializerInfo((ObjectSerializer)((Object)clazz), (Class<?>)object4);
            ((ObjectFieldSerializer)object3).runtimeInfo = runtimeSerializerInfo2;
        }
        object4 = ((ObjectFieldSerializer)object3).runtimeInfo;
        if (object2 == null) {
            if (((ObjectFieldSerializer)object3).writeNumberAsZero && Number.class.isAssignableFrom(((RuntimeSerializerInfo)object4).runtimeFieldClass)) {
                ((JSONSerializer)object).getWriter().write('0');
                return;
            }
            if (((ObjectFieldSerializer)object3).writeNullStringAsEmpty && String.class == ((RuntimeSerializerInfo)object4).runtimeFieldClass) {
                ((JSONSerializer)object).getWriter().write("\"\"");
                return;
            }
            if (((ObjectFieldSerializer)object3).writeNullBooleanAsFalse && Boolean.class == ((RuntimeSerializerInfo)object4).runtimeFieldClass) {
                ((JSONSerializer)object).getWriter().write("false");
                return;
            }
            if (((ObjectFieldSerializer)object3).writeNullListAsEmpty && Collection.class.isAssignableFrom(((RuntimeSerializerInfo)object4).runtimeFieldClass)) {
                ((JSONSerializer)object).getWriter().write("[]");
                return;
            }
            ((RuntimeSerializerInfo)object4).fieldSerializer.write((JSONSerializer)object, null, ((FieldSerializer)object3).fieldInfo.getName(), null);
            return;
        }
        if (((ObjectFieldSerializer)object3).writeEnumUsingToString && ((RuntimeSerializerInfo)object4).runtimeFieldClass.isEnum()) {
            ((JSONSerializer)object).getWriter().writeString(((Enum)object2).name());
            return;
        }
        clazz = object2.getClass();
        if (clazz == ((RuntimeSerializerInfo)object4).runtimeFieldClass) {
            JSONSerializer jSONSerializer = object;
            ObjectFieldSerializer objectFieldSerializer = object3;
            object3 = objectFieldSerializer.fieldInfo.getName();
            object = objectFieldSerializer.fieldInfo.getFieldType();
            ((RuntimeSerializerInfo)object4).fieldSerializer.write(jSONSerializer, object2, object3, (Type)object);
            return;
        }
        ObjectSerializer objectSerializer = ((JSONSerializer)object).getObjectWriter(clazz);
        JSONSerializer jSONSerializer = object;
        ObjectFieldSerializer objectFieldSerializer = object3;
        object3 = objectFieldSerializer.fieldInfo.getName();
        object = objectFieldSerializer.fieldInfo.getFieldType();
        objectSerializer.write(jSONSerializer, object2, object3, (Type)object);
    }

    static class RuntimeSerializerInfo {
        ObjectSerializer fieldSerializer;
        Class<?> runtimeFieldClass;

        public RuntimeSerializerInfo(ObjectSerializer objectSerializer, Class<?> clazz) {
            this.fieldSerializer = objectSerializer;
            this.runtimeFieldClass = clazz;
        }
    }
}

