/*
 * Decompiled with CFR 0.152.
 */
package com.qx.wz.external.fastjson.serializer;

import com.qx.wz.external.fastjson.JSON;
import com.qx.wz.external.fastjson.serializer.BigDecimalCodec;
import com.qx.wz.external.fastjson.serializer.BigIntegerCodec;
import com.qx.wz.external.fastjson.serializer.BooleanArraySerializer;
import com.qx.wz.external.fastjson.serializer.BooleanCodec;
import com.qx.wz.external.fastjson.serializer.ByteArraySerializer;
import com.qx.wz.external.fastjson.serializer.CharArraySerializer;
import com.qx.wz.external.fastjson.serializer.CharacterCodec;
import com.qx.wz.external.fastjson.serializer.CharsetCodec;
import com.qx.wz.external.fastjson.serializer.ClassSerializer;
import com.qx.wz.external.fastjson.serializer.CurrencyCodec;
import com.qx.wz.external.fastjson.serializer.DateFormatSerializer;
import com.qx.wz.external.fastjson.serializer.DoubleArraySerializer;
import com.qx.wz.external.fastjson.serializer.DoubleSerializer;
import com.qx.wz.external.fastjson.serializer.FloatArraySerializer;
import com.qx.wz.external.fastjson.serializer.FloatCodec;
import com.qx.wz.external.fastjson.serializer.InetAddressCodec;
import com.qx.wz.external.fastjson.serializer.InetSocketAddressCodec;
import com.qx.wz.external.fastjson.serializer.IntArraySerializer;
import com.qx.wz.external.fastjson.serializer.IntegerCodec;
import com.qx.wz.external.fastjson.serializer.JavaBeanSerializer;
import com.qx.wz.external.fastjson.serializer.LocaleCodec;
import com.qx.wz.external.fastjson.serializer.LongArraySerializer;
import com.qx.wz.external.fastjson.serializer.LongCodec;
import com.qx.wz.external.fastjson.serializer.ObjectArraySerializer;
import com.qx.wz.external.fastjson.serializer.ObjectSerializer;
import com.qx.wz.external.fastjson.serializer.PatternCodec;
import com.qx.wz.external.fastjson.serializer.ShortArraySerializer;
import com.qx.wz.external.fastjson.serializer.StringCodec;
import com.qx.wz.external.fastjson.serializer.TimeZoneCodec;
import com.qx.wz.external.fastjson.serializer.URICodec;
import com.qx.wz.external.fastjson.serializer.URLCodec;
import com.qx.wz.external.fastjson.serializer.UUIDCodec;
import com.qx.wz.external.fastjson.util.IdentityHashMap;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    private static final SerializeConfig globalInstance = new SerializeConfig();
    private String typeKey;

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int n2) {
        SerializeConfig serializeConfig = this;
        super(n2);
        serializeConfig.typeKey = JSON.DEFAULT_TYPE_KEY;
        serializeConfig.put(Boolean.class, BooleanCodec.instance);
        serializeConfig.put(Character.class, CharacterCodec.instance);
        serializeConfig.put(Byte.class, IntegerCodec.instance);
        serializeConfig.put(Short.class, IntegerCodec.instance);
        serializeConfig.put(Integer.class, IntegerCodec.instance);
        serializeConfig.put(Long.class, LongCodec.instance);
        serializeConfig.put(Float.class, FloatCodec.instance);
        serializeConfig.put(Double.class, DoubleSerializer.instance);
        serializeConfig.put(BigDecimal.class, BigDecimalCodec.instance);
        serializeConfig.put(BigInteger.class, BigIntegerCodec.instance);
        serializeConfig.put(String.class, StringCodec.instance);
        serializeConfig.put(byte[].class, ByteArraySerializer.instance);
        serializeConfig.put(short[].class, ShortArraySerializer.instance);
        serializeConfig.put(int[].class, IntArraySerializer.instance);
        serializeConfig.put(long[].class, LongArraySerializer.instance);
        serializeConfig.put(float[].class, FloatArraySerializer.instance);
        serializeConfig.put(double[].class, DoubleArraySerializer.instance);
        serializeConfig.put(boolean[].class, BooleanArraySerializer.instance);
        serializeConfig.put(char[].class, CharArraySerializer.instance);
        serializeConfig.put(Object[].class, ObjectArraySerializer.instance);
        serializeConfig.put(Class.class, ClassSerializer.instance);
        serializeConfig.put(SimpleDateFormat.class, DateFormatSerializer.instance);
        serializeConfig.put(Locale.class, LocaleCodec.instance);
        serializeConfig.put(Currency.class, CurrencyCodec.instance);
        serializeConfig.put(TimeZone.class, TimeZoneCodec.instance);
        serializeConfig.put(UUID.class, UUIDCodec.instance);
        serializeConfig.put(InetAddress.class, InetAddressCodec.instance);
        serializeConfig.put(Inet4Address.class, InetAddressCodec.instance);
        serializeConfig.put(Inet6Address.class, InetAddressCodec.instance);
        serializeConfig.put(InetSocketAddress.class, InetSocketAddressCodec.instance);
        serializeConfig.put(URI.class, URICodec.instance);
        serializeConfig.put(URL.class, URLCodec.instance);
        serializeConfig.put(Pattern.class, PatternCodec.instance);
        serializeConfig.put(Charset.class, CharsetCodec.instance);
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String string) {
        this.typeKey = string;
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        return new JavaBeanSerializer(clazz);
    }
}

